/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.jsf;

import org.apache.myfaces.orchestra.conversation.ConversationManager;

import javax.faces.context.FacesContext;

/**
 * Some helpers usable for public use
 */
public final class JsfConversationUtils
{
    private JsfConversationUtils()
    {
    }

    /**
     * <p>if no conversation with name <code>conversationName</code> is active a navigation with
     * the given action will be issued</p>
     * <p/>
     * Notice: optionally you can use the conversationName as "fromAction" in your faces-config.xml
     * </p>
     */
    public static void ensureConversation(String conversationName, String action)
    {
        if (!ConversationManager.getInstance().hasConversation(conversationName))
        {
            FacesContext.getCurrentInstance().getApplication().getNavigationHandler().handleNavigation(
                FacesContext.getCurrentInstance(),
                conversationName,
                action
            );
        }
    }
}
