/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.NamedArgument;
import org.apache.myfaces.extensions.cdi.message.impl.AbstractFormatterAwareMessageInterpolator;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultArgumentFilter;
import org.apache.myfaces.extensions.cdi.message.impl.spi.ArgumentFilter;
import org.apache.myfaces.extensions.cdi.message.impl.spi.ELProvider;
import org.apache.myfaces.extensions.cdi.message.impl.spi.SimpleELContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELAwareMessageInterpolator
extends AbstractFormatterAwareMessageInterpolator {
    private static final long serialVersionUID = 3451979493272628741L;
    private static final Pattern MESSAGE_ARGS_PATTERN = Pattern.compile("\\{([^\\}]+?)\\}");
    private ELProvider elProvider;
    private ArgumentFilter argumentFilter;

    public ELAwareMessageInterpolator(ELProvider elProvider) {
        this(elProvider, null);
    }

    public ELAwareMessageInterpolator(ELProvider elProvider, ArgumentFilter argumentFilter) {
        this.elProvider = elProvider;
        this.argumentFilter = argumentFilter != null ? argumentFilter : new DefaultArgumentFilter();
    }

    public String interpolate(MessageContext messageContext, String messageDescriptor, Serializable ... arguments) {
        List<NamedArgument> namedArguments = this.addNamedArguments(arguments);
        if (namedArguments.size() > 0) {
            return this.interpolateNamedArguments(messageContext, messageDescriptor, namedArguments);
        }
        return messageDescriptor;
    }

    private List<NamedArgument> addNamedArguments(Serializable[] arguments) {
        ArrayList<NamedArgument> result = new ArrayList<NamedArgument>();
        for (Serializable argument : arguments) {
            if (!(argument instanceof NamedArgument)) continue;
            result.add((NamedArgument)argument);
        }
        return result;
    }

    private synchronized String interpolateNamedArguments(MessageContext messageContext, String messageDescriptor, List<NamedArgument> namedArguments) {
        ExpressionFactory factory = this.elProvider.createExpressionFactory();
        SimpleELContext elContext = this.elProvider.createELContext(this.elProvider.createELResolver());
        for (NamedArgument argument : namedArguments) {
            Serializable value = argument.getValue();
            Class valueType = value != null ? value.getClass() : Object.class;
            elContext.setVariable(argument.getName(), factory.createValueExpression((Object)value, valueType));
        }
        Matcher matcher = MESSAGE_ARGS_PATTERN.matcher(messageDescriptor);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            ValueExpression valueExpression;
            Object value;
            String expression = matcher.group(1);
            String resolvedArgumentValue = this.argumentFilter.isArgumentAllowed(expression, value = (valueExpression = factory.createValueExpression((ELContext)elContext, "${" + expression + "}", Object.class)).getValue((ELContext)elContext)) ? this.formatAsString(messageContext, value).toString() : this.argumentFilter.getDefaultValue(expression);
            matcher.appendReplacement(buffer, "");
            buffer.append(resolvedArgumentValue);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

