/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.impl.DefaultFacesConfigurationProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class FacesConfigurationProviderFactory {
    protected static final String FACTORY_DEFAULT = DefaultFacesConfigurationProviderFactory.class.getName();
    private static final String FACTORY_KEY = FacesConfigurationProviderFactory.class.getName();

    public static FacesConfigurationProviderFactory getFacesConfigurationProviderFactory(ExternalContext ctx) {
        FacesConfigurationProviderFactory factory = (FacesConfigurationProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (factory != null) {
            return factory;
        }
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                factory = (FacesConfigurationProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, FacesConfigurationProviderFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                factory = (FacesConfigurationProviderFactory)SpiUtils.build(ctx, FacesConfigurationProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (factory != null) {
            FacesConfigurationProviderFactory.setFacesConfigurationProviderFactory(ctx, factory);
        }
        return factory;
    }

    public static void setFacesConfigurationProviderFactory(ExternalContext ctx, FacesConfigurationProviderFactory factory) {
        ctx.getApplicationMap().put(FACTORY_KEY, factory);
    }

    public abstract FacesConfigurationProvider getFacesConfigurationProvider(ExternalContext var1);
}

