/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.BufferedByteHolderInputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;

public class OverflowInputStream
extends BufferedByteHolderInputStream
implements Resetable {
    protected BaseContainerHandle owner;
    protected long overflowPage;
    protected int overflowId;
    protected long firstOverflowPage;
    protected int firstOverflowId;
    protected RecordHandle recordToLock;

    public OverflowInputStream(ByteHolder byteHolder, BaseContainerHandle baseContainerHandle, long l, int n, RecordHandle recordHandle) throws IOException, StandardException {
        super(byteHolder);
        this.owner = baseContainerHandle;
        this.overflowPage = l;
        this.overflowId = n;
        this.firstOverflowPage = l;
        this.firstOverflowId = n;
        this.recordToLock = recordHandle;
        this.fillByteHolder();
    }

    public void fillByteHolder() throws IOException {
        if (this.bh.available() == 0 && this.overflowPage != -1L) {
            this.bh.clear();
            try {
                BasePage basePage = (BasePage)this.owner.getPage(this.overflowPage);
                if (basePage != null) {
                    basePage.restorePortionLongColumn(this);
                    basePage.unlatch();
                    basePage = null;
                }
            }
            catch (StandardException standardException) {
                throw new IOException(standardException.toString());
            }
            this.bh.startReading();
        }
    }

    public long getOverflowPage() {
        return this.overflowPage;
    }

    public int getOverflowId() {
        return this.overflowId;
    }

    public void setOverflowPage(long l) {
        this.overflowPage = l;
    }

    public void setOverflowId(int n) {
        this.overflowId = n;
    }

    public void resetStream() throws IOException, StandardException {
        this.owner.checkOpen();
        this.overflowPage = this.firstOverflowPage;
        this.overflowId = this.firstOverflowId;
        this.bh.clear();
        this.bh.startReading();
        this.fillByteHolder();
    }

    public void initStream() throws StandardException {
        if (this.owner.getTransaction() == null) {
            throw StandardException.newException("40XD0");
        }
        LockingPolicy lockingPolicy = this.owner.getTransaction().newLockingPolicy(1, 4, true);
        this.owner = (BaseContainerHandle)this.owner.getTransaction().openContainer(this.owner.getId(), lockingPolicy, this.owner.getMode());
        this.owner.getLockingPolicy().lockRecordForRead(this.owner.getTransaction(), this.owner, this.recordToLock, true, false);
    }

    public void closeStream() {
        this.owner.close();
    }
}

