/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.stanza;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.vysper.xml.fragment.AbstractXMLElementBuilder;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLFragment;
import org.apache.vysper.xml.fragment.XMLText;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.protocol.commandstanza.EndOfSessionCommandStanza;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.MessageStanzaType;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StanzaBuilder
extends AbstractXMLElementBuilder<StanzaBuilder, Stanza> {
    public static StanzaBuilder createIQStanza(Entity from, Entity to, IQStanzaType type, String id) {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("iq", "jabber:client");
        if (from != null) {
            stanzaBuilder.addAttribute("from", from.getFullQualifiedName());
        }
        if (to != null) {
            stanzaBuilder.addAttribute("to", to.getFullQualifiedName());
        }
        stanzaBuilder.addAttribute("type", type.value());
        stanzaBuilder.addAttribute("id", id);
        return stanzaBuilder;
    }

    public static StanzaBuilder createMessageStanza(Entity from, Entity to, String lang, String body) {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("message", "jabber:client");
        stanzaBuilder.addAttribute("from", from.getFullQualifiedName());
        stanzaBuilder.addAttribute("to", to.getFullQualifiedName());
        if (lang != null) {
            stanzaBuilder.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", lang);
        }
        if (body != null) {
            ((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("body", "jabber:client")).addText(body)).endInnerElement();
        }
        return stanzaBuilder;
    }

    public static StanzaBuilder createMessageStanza(Entity from, Entity to, MessageStanzaType type, String lang, String body) {
        StanzaBuilder stanzaBuilder = StanzaBuilder.createMessageStanza(from, to, lang, body);
        if (type != null) {
            stanzaBuilder.addAttribute("type", type.value());
        }
        return stanzaBuilder;
    }

    public static Stanza createUnavailablePresenceStanza(String status, SessionContext.SessionTerminationCause terminationCause) {
        StanzaBuilder presenceUnavailBuilder = StanzaBuilder.createPresenceStanza(null, null, null, PresenceStanzaType.UNAVAILABLE, null, status);
        if (terminationCause == null) {
            return (Stanza)presenceUnavailBuilder.build();
        }
        return new EndOfSessionCommandStanza((Stanza)presenceUnavailBuilder.build(), terminationCause);
    }

    public static StanzaBuilder createPresenceStanza(Entity from, Entity to, String lang, PresenceStanzaType type, String show, String status) {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("presence", "jabber:client");
        if (from != null) {
            stanzaBuilder.addAttribute("from", from.getFullQualifiedName());
        }
        if (to != null) {
            stanzaBuilder.addAttribute("to", to.getFullQualifiedName());
        }
        if (lang != null) {
            stanzaBuilder.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", lang);
        }
        if (type != null) {
            stanzaBuilder.addAttribute("type", type.value());
        }
        if (show != null) {
            ((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("show", "jabber:client")).addText(show)).endInnerElement();
        }
        if (status != null) {
            ((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("status", "jabber:client")).addText(status)).endInnerElement();
        }
        return stanzaBuilder;
    }

    public static StanzaBuilder createDirectReply(XMPPCoreStanza original, boolean fromIsServerOnly, IQStanzaType type) {
        return StanzaBuilder.createDirectReply(original, fromIsServerOnly, type == null ? null : type.value());
    }

    public static StanzaBuilder createDirectReply(XMPPCoreStanza original, boolean fromIsServerOnly, String type) {
        Entity newFrom;
        if (original == null) {
            throw new IllegalArgumentException();
        }
        StanzaBuilder stanzaBuilder = new StanzaBuilder(original.getName(), original.getNamespaceURI(), original.getNamespacePrefix());
        Entity newTo = original.getFrom();
        if (newTo != null) {
            stanzaBuilder.addAttribute("to", newTo.getFullQualifiedName());
        }
        if ((newFrom = original.getTo()) != null) {
            if (fromIsServerOnly) {
                newFrom = new EntityImpl(null, newFrom.getDomain(), null);
            }
            stanzaBuilder.addAttribute("from", newFrom.getFullQualifiedName());
        }
        stanzaBuilder.addAttribute("type", type);
        if (original.getID() != null) {
            stanzaBuilder.addAttribute("id", original.getID());
        }
        return stanzaBuilder;
    }

    public static StanzaBuilder createClone(XMLElement original, boolean deep, List<Attribute> replacingAttributes) {
        StanzaBuilder stanzaBuilder = new StanzaBuilder(original.getName(), original.getNamespaceURI(), original.getNamespacePrefix());
        ArrayList<Attribute> replacingAttributesCopy = new ArrayList<Attribute>();
        if (replacingAttributes != null) {
            replacingAttributesCopy.addAll(replacingAttributes);
        }
        List originalAttributes = original.getAttributes();
        for (Attribute originalAttribute : originalAttributes) {
            boolean wasReplaced = false;
            Iterator it = replacingAttributesCopy.iterator();
            while (it.hasNext()) {
                Attribute replacingAttribute = (Attribute)it.next();
                if (replacingAttribute == null || !replacingAttribute.getName().equals(originalAttribute.getName())) continue;
                stanzaBuilder.addAttribute(replacingAttribute);
                it.remove();
                wasReplaced = true;
                break;
            }
            if (wasReplaced) continue;
            stanzaBuilder.addAttribute(originalAttribute);
        }
        for (Attribute additionalAttribute : replacingAttributesCopy) {
            stanzaBuilder.addAttribute(additionalAttribute);
        }
        if (deep && original.getInnerElements() != null) {
            List innerElements = original.getInnerElements();
            for (XMLElement innerElement : innerElements) {
                stanzaBuilder.addPreparedElement(innerElement);
            }
        }
        return stanzaBuilder;
    }

    public static StanzaBuilder createForward(Stanza original, Entity from, Entity to) {
        ArrayList<Attribute> toFromReplacements = new ArrayList<Attribute>(2);
        if (to != null) {
            toFromReplacements.add(new Attribute("to", to.getFullQualifiedName()));
        }
        if (from != null) {
            toFromReplacements.add(new Attribute("from", from.getFullQualifiedName()));
        }
        return StanzaBuilder.createClone(original, true, toFromReplacements);
    }

    public static Stanza createForwardStanza(Stanza original, Entity from, Entity to) {
        return (Stanza)StanzaBuilder.createForward(original, from, to).build();
    }

    public static Stanza rewriteNamespace(Stanza stanza, String fromNamespaceUri, String toNamespaceUri) {
        StanzaBuilder builder = new StanzaBuilder(stanza.getName(), toNamespaceUri, stanza.getNamespacePrefix());
        for (Attribute attribute : stanza.getAttributes()) {
            builder.addAttribute(attribute);
        }
        for (XMLFragment fragment : stanza.getInnerFragments()) {
            if (fragment instanceof XMLElement) {
                StanzaBuilder.rewriteNamespace((XMLElement)fragment, builder, fromNamespaceUri, toNamespaceUri);
                continue;
            }
            builder.addText(((XMLText)fragment).getText());
        }
        return (Stanza)builder.build();
    }

    private static void rewriteNamespace(XMLElement element, StanzaBuilder builder, String fromNamespaceUri, String toNamespaceUri) {
        if (fromNamespaceUri.equals(element.getNamespaceURI())) {
            builder.startInnerElement(element.getName(), toNamespaceUri);
            for (Attribute attribute : element.getAttributes()) {
                builder.addAttribute(attribute);
            }
            for (XMLFragment fragment : element.getInnerFragments()) {
                if (fragment instanceof XMLElement) {
                    StanzaBuilder.rewriteNamespace((XMLElement)fragment, builder, fromNamespaceUri, toNamespaceUri);
                    continue;
                }
                builder.addText(((XMLText)fragment).getText());
            }
            builder.endInnerElement();
        } else {
            builder.addPreparedElement(element);
        }
    }

    public StanzaBuilder(String stanzaName) {
        this(stanzaName, null);
    }

    public StanzaBuilder(String stanzaName, String namespaceURI) {
        this(stanzaName, namespaceURI, null);
    }

    public StanzaBuilder(String stanzaName, String namespaceURI, String namespacePrefix) {
        super(stanzaName, namespaceURI, namespacePrefix);
    }

    public StanzaBuilder(String stanzaName, String namespaceURI, String namespacePrefix, List<Attribute> attributes, List<XMLFragment> innerFragments) {
        super(stanzaName, namespaceURI, namespacePrefix, attributes, null, innerFragments);
    }

    public StanzaBuilder(String stanzaName, String namespaceURI, String namespacePrefix, List<Attribute> attributes, Map<String, String> namespaces, List<XMLFragment> innerFragments) {
        super(stanzaName, namespaceURI, namespacePrefix, attributes, namespaces, innerFragments);
    }

    protected XMLElement createElement(String namespaceURI, String name, String namespacePrefix, List<Attribute> attributes, Map<String, String> namespaces, List<XMLFragment> innerFragments) {
        if (this.currentElement == null) {
            return new Stanza(namespaceURI, name, namespacePrefix, attributes, innerFragments, namespaces);
        }
        return new XMLElement(namespaceURI, name, namespacePrefix, attributes, innerFragments, namespaces);
    }

    static class ElementStruct {
        public ElementStruct parentElement = null;
        public XMLElement element = null;
        public List<Attribute> attributes = null;
        public List<XMLFragment> innerFragments = null;

        ElementStruct() {
        }
    }
}

