/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.servicediscovery.management;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;

public class Item {
    protected Entity jid;
    protected String name;
    protected String node;

    public Item(Entity jid, String name, String node) {
        if (jid == null) {
            throw new IllegalArgumentException("jid may not be null");
        }
        this.jid = jid;
        this.name = name;
        this.node = node;
    }

    public Item(Entity jid, String name) {
        this(jid, name, null);
    }

    public Item(Entity jid) {
        this(jid, null, null);
    }

    public Entity getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public String getNode() {
        return this.node;
    }

    public void insertElement(StanzaBuilder stanzaBuilder) {
        stanzaBuilder.startInnerElement("item", "http://jabber.org/protocol/disco#items");
        if (this.jid != null) {
            stanzaBuilder.addAttribute("jid", this.jid.getFullQualifiedName());
        }
        if (this.name != null) {
            stanzaBuilder.addAttribute("name", this.name);
        }
        if (this.node != null) {
            stanzaBuilder.addAttribute("node", this.node);
        }
        stanzaBuilder.endInnerElement();
    }
}

