/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.starttls.handler;

import org.apache.vysper.xml.fragment.XMLElementVerifier;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainerImpl;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.server.response.ServerResponses;
import org.apache.vysper.xmpp.stanza.Stanza;

public class StartTLSHandler
implements StanzaHandler {
    public String getName() {
        return "starttls";
    }

    public boolean verify(Stanza stanza) {
        if (stanza == null) {
            return false;
        }
        return this.getName().equals(stanza.getName());
    }

    public boolean isSessionRequired() {
        return true;
    }

    public ResponseStanzaContainer execute(Stanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        XMLElementVerifier xmlElementVerifier = stanza.getVerifier();
        boolean tlsNamespace = xmlElementVerifier.namespacePresent("urn:ietf:params:xml:ns:xmpp-tls");
        if (!tlsNamespace) {
            return this.respondTLSFailure();
        }
        if (sessionStateHolder.getState() != SessionState.STARTED) {
            return this.respondTLSFailure();
        }
        Stanza responseStanza = new ServerResponses().getTLSProceed();
        sessionStateHolder.setState(SessionState.ENCRYPTION_STARTED);
        sessionContext.switchToTLS(true, false);
        return new ResponseStanzaContainerImpl(responseStanza);
    }

    private ResponseStanzaContainer respondTLSFailure() {
        return new ResponseStanzaContainerImpl(ServerErrorResponses.getTLSFailure());
    }
}

