/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.im.handler;

import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.delivery.LocalDeliveryUtils;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.core.im.handler.AbstractPresenceSpecializedHandler;
import org.apache.vysper.xmpp.modules.roster.AskSubscriptionType;
import org.apache.vysper.xmpp.modules.roster.RosterException;
import org.apache.vysper.xmpp.modules.roster.RosterItem;
import org.apache.vysper.xmpp.modules.roster.RosterStanzaUtils;
import org.apache.vysper.xmpp.modules.roster.RosterSubscriptionMutator;
import org.apache.vysper.xmpp.modules.roster.SubscriptionType;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManager;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanzaVerifier;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresenceSubscriptionHandler
extends AbstractPresenceSpecializedHandler {
    final Logger logger = LoggerFactory.getLogger(PresenceSubscriptionHandler.class);

    Stanza executeCorePresence(ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, PresenceStanza presenceStanza, RosterManager rosterManager) {
        if (!PresenceStanzaType.isSubscriptionType(presenceStanza.getPresenceType())) {
            throw new RuntimeException("case not handled in availability handler" + presenceStanza.getPresenceType().value());
        }
        Entity initiatingEntity = sessionContext == null ? null : sessionContext.getInitiatingEntity();
        XMPPCoreStanzaVerifier verifier = presenceStanza.getCoreVerifier();
        ResourceRegistry registry = serverRuntimeContext.getResourceRegistry();
        PresenceStanzaType type = presenceStanza.getPresenceType();
        if (isOutboundStanza) {
            Entity user = initiatingEntity;
            PresenceStanza stampedStanza = this.buildPresenceStanza(user.getBareJID(), presenceStanza.getTo().getBareJID(), presenceStanza.getPresenceType(), null);
            switch (type) {
                case SUBSCRIBE: {
                    this.handleOutboundSubscriptionRequest(stampedStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
                    break;
                }
                case SUBSCRIBED: {
                    this.handleOutboundSubscriptionApproval(stampedStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
                    break;
                }
                case UNSUBSCRIBE: {
                    this.handleOutboundUnsubscription(stampedStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
                    break;
                }
                case UNSUBSCRIBED: {
                    this.handleOutboundSubscriptionCancellation(stampedStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled case " + type.value());
                }
            }
        } else {
            switch (type) {
                case SUBSCRIBE: {
                    return this.handleInboundSubscriptionRequest(presenceStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
                }
                case SUBSCRIBED: {
                    return this.handleInboundSubscriptionApproval(presenceStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
                }
                case UNSUBSCRIBE: {
                    this.handleInboundUnsubscription(presenceStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
                    return null;
                }
                case UNSUBSCRIBED: {
                    this.handleInboundSubscriptionCancellation(presenceStanza, serverRuntimeContext, sessionContext, registry, rosterManager);
                    return null;
                }
            }
            throw new RuntimeException("unhandled case " + type.value());
        }
        return null;
    }

    protected void handleInboundUnsubscription(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        RosterItem rosterItem;
        Entity contact = stanza.getFrom();
        Entity user = stanza.getTo();
        Entity userBareJid = user.getBareJID();
        Entity contactBareJid = contact.getBareJID();
        try {
            rosterItem = rosterManager.getContact(userBareJid, contactBareJid);
        }
        catch (RosterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (rosterItem == null) {
            return;
        }
        RosterSubscriptionMutator.Result result = RosterSubscriptionMutator.getInstance().remove(rosterItem, SubscriptionType.FROM);
        if (result != RosterSubscriptionMutator.Result.OK) {
            return;
        }
        List<String> resources = registry.getInterestedResources(user);
        for (String resource : resources) {
            EntityImpl userResource = new EntityImpl(user, resource);
            Stanza push = RosterStanzaUtils.createRosterItemPushIQ(userResource, sessionContext.nextSequenceValue(), rosterItem);
            LocalDeliveryUtils.relayToResourceDirectly(registry, resource, push);
        }
    }

    protected void handleOutboundUnsubscription(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        Entity user = stanza.getFrom();
        Entity contact = stanza.getTo();
        Entity userBareJid = user.getBareJID();
        Entity contactBareJid = contact.getBareJID();
        this.relayStanza(contact, stanza, sessionContext);
        RosterItem rosterItem = null;
        try {
            rosterItem = rosterManager.getContact(userBareJid, contactBareJid);
        }
        catch (RosterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (rosterItem == null) {
            return;
        }
        RosterSubscriptionMutator.Result result = RosterSubscriptionMutator.getInstance().remove(rosterItem, SubscriptionType.TO);
        if (result != RosterSubscriptionMutator.Result.OK) {
            return;
        }
        this.relayStanza(contact, stanza, sessionContext);
        this.sendRosterUpdate(sessionContext, registry, user, rosterItem);
    }

    protected void sendRosterUpdate(SessionContext sessionContext, ResourceRegistry registry, Entity user, RosterItem rosterItem) {
        List<String> resources = registry.getInterestedResources(user);
        for (String resource : resources) {
            EntityImpl userResource = new EntityImpl(user, resource);
            Stanza push = RosterStanzaUtils.createRosterItemPushIQ(userResource, sessionContext.nextSequenceValue(), rosterItem);
            LocalDeliveryUtils.relayToResourceDirectly(registry, resource, push);
        }
    }

    protected void handleInboundSubscriptionCancellation(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        RosterItem rosterItem;
        Entity contact = stanza.getFrom();
        Entity user = stanza.getTo();
        Entity userBareJid = user.getBareJID();
        Entity contactBareJid = contact.getBareJID();
        try {
            rosterItem = rosterManager.getContact(userBareJid, contactBareJid);
        }
        catch (RosterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (rosterItem == null) {
            return;
        }
        RosterSubscriptionMutator.Result result = RosterSubscriptionMutator.getInstance().remove(rosterItem, SubscriptionType.TO);
        if (result != RosterSubscriptionMutator.Result.OK) {
            return;
        }
        List<String> resources = registry.getInterestedResources(user);
        for (String resource : resources) {
            EntityImpl userResource = new EntityImpl(user, resource);
            Stanza push = RosterStanzaUtils.createRosterItemPushIQ(userResource, sessionContext.nextSequenceValue(), rosterItem);
            LocalDeliveryUtils.relayToResourceDirectly(registry, resource, push);
        }
    }

    protected void handleOutboundSubscriptionCancellation(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        Entity user = stanza.getFrom();
        Entity contact = stanza.getTo();
        Entity userBareJid = user.getBareJID();
        Entity contactBareJid = contact.getBareJID();
        RosterItem rosterItem = null;
        try {
            rosterItem = rosterManager.getContact(userBareJid, contactBareJid);
        }
        catch (RosterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (rosterItem == null) {
            return;
        }
        RosterSubscriptionMutator.Result result = RosterSubscriptionMutator.getInstance().remove(rosterItem, SubscriptionType.FROM);
        if (result != RosterSubscriptionMutator.Result.OK) {
            return;
        }
        this.relayStanza(contact, stanza, sessionContext);
        this.sendRosterUpdate(sessionContext, registry, user, rosterItem);
    }

    protected void handleOutboundSubscriptionApproval(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        Entity user = stanza.getFrom();
        Entity contact = stanza.getTo();
        Entity userBareJid = user.getBareJID();
        Entity contactBareJid = contact.getBareJID();
        RosterItem rosterItem = null;
        try {
            rosterItem = this.getExistingOrNewRosterItem(rosterManager, userBareJid, contactBareJid);
            RosterSubscriptionMutator.Result result = RosterSubscriptionMutator.getInstance().add(rosterItem, SubscriptionType.FROM);
            if (result != RosterSubscriptionMutator.Result.OK) {
                return;
            }
            rosterManager.addContact(userBareJid, rosterItem);
        }
        catch (RosterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.relayStanza(contact, stanza, sessionContext);
        this.sendRosterUpdate(sessionContext, registry, user, rosterItem);
        List<String> resources = registry.getAvailableResources(user);
        for (String resource : resources) {
            EntityImpl userResource = new EntityImpl(user, resource);
            PresenceStanza cachedPresenceStanza = sessionContext.getServerRuntimeContext().getPresenceCache().get(userResource);
            if (cachedPresenceStanza == null) continue;
            PresenceStanza sendoutPresence = this.buildPresenceStanza(userResource, contactBareJid, null, cachedPresenceStanza.getInnerElements());
            this.relayStanza(contact, sendoutPresence, sessionContext);
        }
    }

    private RosterItem getExistingOrNewRosterItem(RosterManager rosterManager, Entity userJid, Entity contactJid) throws RosterException {
        RosterItem rosterItem = rosterManager.getContact(userJid, contactJid);
        if (rosterItem == null) {
            rosterItem = new RosterItem(contactJid, SubscriptionType.NONE);
        }
        return rosterItem;
    }

    protected Stanza handleInboundSubscriptionApproval(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        RosterSubscriptionMutator.Result result;
        RosterItem rosterItem;
        Entity contact = stanza.getFrom();
        Entity user = stanza.getTo();
        Entity userBareJid = user.getBareJID();
        try {
            rosterItem = this.getExistingOrNewRosterItem(rosterManager, userBareJid, contact);
            result = RosterSubscriptionMutator.getInstance().add(rosterItem, SubscriptionType.TO);
            rosterManager.addContact(userBareJid, rosterItem);
        }
        catch (RosterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (result == RosterSubscriptionMutator.Result.OK || result == RosterSubscriptionMutator.Result.ALREADY_SET) {
            List<String> resources = registry.getInterestedResources(user);
            for (String resource : resources) {
                EntityImpl userResource = new EntityImpl(user, resource);
                Stanza push = RosterStanzaUtils.createRosterItemPushIQ(userResource, sessionContext.nextSequenceValue(), rosterItem);
                LocalDeliveryUtils.relayToResourceDirectly(registry, resource, push);
            }
        }
        return null;
    }

    protected Stanza handleInboundSubscriptionRequest(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        RosterSubscriptionMutator.Result result;
        Entity contact = stanza.getFrom();
        Entity user = stanza.getTo();
        Entity userBareJid = user.getBareJID();
        try {
            RosterItem rosterItem = this.getExistingOrNewRosterItem(rosterManager, userBareJid, contact);
            result = RosterSubscriptionMutator.getInstance().add(rosterItem, AskSubscriptionType.ASK_SUBSCRIBED);
            rosterManager.addContact(userBareJid, rosterItem);
        }
        catch (RosterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (result == RosterSubscriptionMutator.Result.ALREADY_SET) {
            Entity receiver = contact.getBareJID();
            PresenceStanza alreadySubscribedResponse = this.buildPresenceStanza(userBareJid, receiver, PresenceStanzaType.SUBSCRIBED, null);
            this.relayStanza(receiver, alreadySubscribedResponse, sessionContext);
            return null;
        }
        sessionContext.getResponseWriter().write(stanza);
        return null;
    }

    protected void handleOutboundSubscriptionRequest(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, ResourceRegistry registry, RosterManager rosterManager) {
        StanzaRelay stanzaRelay = serverRuntimeContext.getStanzaRelay();
        Entity user = stanza.getFrom();
        Entity contact = stanza.getTo().getBareJID();
        RosterItem rosterItem = null;
        try {
            rosterItem = this.getExistingOrNewRosterItem(rosterManager, user.getBareJID(), contact);
            RosterSubscriptionMutator.Result result = RosterSubscriptionMutator.getInstance().add(rosterItem, AskSubscriptionType.ASK_SUBSCRIBE);
            if (result != RosterSubscriptionMutator.Result.OK) {
                return;
            }
            rosterManager.addContact(user.getBareJID(), rosterItem);
        }
        catch (RosterException e) {
            throw new RuntimeException(e);
        }
        try {
            stanzaRelay.relay(stanza.getTo(), stanza, new IgnoreFailureStrategy());
        }
        catch (DeliveryException e) {
            e.printStackTrace();
        }
        List<String> resources = registry.getInterestedResources(user);
        for (String resource : resources) {
            EntityImpl userResource = new EntityImpl(user, resource);
            Stanza push = RosterStanzaUtils.createRosterItemPushIQ(userResource, sessionContext.nextSequenceValue(), rosterItem);
            LocalDeliveryUtils.relayToResourceDirectly(registry, resource, push);
        }
    }
}

