/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.authorization;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.vysper.xml.fragment.XMLText;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AuthorizationResponses;
import org.apache.vysper.xmpp.authorization.SASLMechanism;
import org.apache.vysper.xmpp.modules.core.sasl.SASLFailureType;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;

public class Plain
implements SASLMechanism {
    private static final AuthorizationResponses AUTHORIZATION_RESPONSES = new AuthorizationResponses();

    public String getName() {
        return "PLAIN";
    }

    public Stanza started(SessionContext sessionContext, SessionStateHolder sessionStateHolder, Stanza authStanza) {
        EntityImpl initiatingEntity;
        byte[] decoded;
        List innerTexts = authStanza.getInnerTexts();
        if (innerTexts == null || innerTexts.isEmpty()) {
            return AUTHORIZATION_RESPONSES.getFailureMalformedRequest();
        }
        XMLText base64Encoded = (XMLText)innerTexts.get(0);
        try {
            decoded = Base64.decodeBase64((byte[])base64Encoded.getText().getBytes());
        }
        catch (Throwable e) {
            return AUTHORIZATION_RESPONSES.getFailure(SASLFailureType.INCORRECT_ENCODING);
        }
        ArrayList<String> decodedParts = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < decoded.length; ++i) {
            char ch = (char)decoded[i];
            if (ch != '\u0000') {
                stringBuilder.append(ch);
            }
            if (ch != '\u0000' && i != decoded.length - 1) continue;
            decodedParts.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        if (decodedParts.size() != 3) {
            return AUTHORIZATION_RESPONSES.getFailureMalformedRequest();
        }
        String alias = (String)decodedParts.get(0);
        String username = (String)decodedParts.get(1);
        String password = (String)decodedParts.get(2);
        if (!username.contains("@")) {
            username = username + "@" + sessionContext.getServerJID().getDomain();
        }
        try {
            initiatingEntity = EntityImpl.parse(username);
        }
        catch (EntityFormatException e) {
            return AUTHORIZATION_RESPONSES.getFailureNotAuthorized();
        }
        boolean authorized = sessionContext.getServerRuntimeContext().getUserAuthorization().verifyCredentials(username, password, null);
        if (authorized) {
            sessionContext.setInitiatingEntity(initiatingEntity);
            sessionStateHolder.setState(SessionState.AUTHENTICATED);
            return AUTHORIZATION_RESPONSES.getSuccess();
        }
        return AUTHORIZATION_RESPONSES.getFailureNotAuthorized();
    }
}

