/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.writer;

import java.util.Iterator;
import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xml.fragment.XMLText;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenseStanzaLogRenderer {
    static final Logger logger = LoggerFactory.getLogger(DenseStanzaLogRenderer.class);
    private static final String ELEMENT_SEPARATOR = ".";
    private static final String ATTR_QUOTE = "'";
    private static final String EQUALS = "=";

    public static String render(XMLElement stanza) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (stanza == null) {
                return stringBuilder.append("NULL_STANZA").toString();
            }
            String outerName = stanza.getName();
            stringBuilder.append(outerName);
            XMLElement firstInnerElement = stanza.getFirstInnerElement();
            if ("stream".equals(outerName)) {
                DenseStanzaLogRenderer.renderStreamStart(stringBuilder, stanza, firstInnerElement);
            } else if ("message".equals(outerName)) {
                DenseStanzaLogRenderer.renderMessage(stringBuilder, stanza, firstInnerElement);
            } else if ("error".equals(outerName)) {
                DenseStanzaLogRenderer.renderError(stringBuilder, stanza, firstInnerElement);
            } else if ("presence".equals(outerName)) {
                DenseStanzaLogRenderer.renderPresence(stringBuilder, stanza, firstInnerElement);
            } else if ("auth".equals(outerName)) {
                DenseStanzaLogRenderer.renderAuth(stringBuilder, stanza, firstInnerElement);
            } else if ("iq".equals(outerName)) {
                DenseStanzaLogRenderer.renderIQ(stringBuilder, stanza, firstInnerElement);
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            logger.warn("error when rendering stanza {}: {}", (Object)stanza.toString(), (Object)e);
            return "*render-exception*";
        }
    }

    private static void renderIQ(StringBuilder stringBuilder, XMLElement stanza, XMLElement firstInnerElement) {
        IQStanza iq = (IQStanza)XMPPCoreStanza.getWrapper((Stanza)stanza);
        DenseStanzaLogRenderer.renderAttribute(stringBuilder, iq, "id");
        DenseStanzaLogRenderer.renderAttribute(stringBuilder, iq, "to");
        DenseStanzaLogRenderer.renderAttribute(stringBuilder, iq, "from");
        DenseStanzaLogRenderer.renderAttribute(stringBuilder, iq, "type");
        if (firstInnerElement != null) {
            stringBuilder.append(ELEMENT_SEPARATOR).append(firstInnerElement.getName());
            if ("query".equals(firstInnerElement.getName())) {
                DenseStanzaLogRenderer.renderIQQuery(stringBuilder, firstInnerElement);
            } else {
                DenseStanzaLogRenderer.renderNamespace(stringBuilder, firstInnerElement);
            }
        }
    }

    private static void renderIQQuery(StringBuilder stringBuilder, XMLElement queryElement) {
        String nsUri = queryElement.getNamespaceURI();
        if (nsUri == null) {
            stringBuilder.append(ELEMENT_SEPARATOR).append("?").append("xmlns").append("?");
            return;
        }
        if (!nsUri.startsWith("http://jabber.org/protocol/disco")) {
            DenseStanzaLogRenderer.renderNamespace(stringBuilder, queryElement);
            return;
        }
        stringBuilder.append(ELEMENT_SEPARATOR).append("disco");
        if (nsUri.equals("http://jabber.org/protocol/disco#items")) {
            stringBuilder.append(ELEMENT_SEPARATOR).append("items");
        } else if (nsUri.equals("http://jabber.org/protocol/disco#info")) {
            stringBuilder.append(ELEMENT_SEPARATOR).append("info");
            List features = queryElement.getInnerElementsNamed("feature");
            if (features != null) {
                for (XMLElement feature : features) {
                    String varAttrValue = feature.getAttributeValue("var");
                    if (varAttrValue == null) {
                        varAttrValue = "NOT_GIVEN";
                    }
                    DenseStanzaLogRenderer.renderAttributeForm(stringBuilder, "feature", varAttrValue);
                }
            }
        } else {
            stringBuilder.append(ELEMENT_SEPARATOR).append("????");
        }
    }

    private static void renderAuth(StringBuilder stringBuilder, XMLElement stanza, XMLElement firstInnerElement) {
        DenseStanzaLogRenderer.renderAttribute(stringBuilder, stanza, "mechanism");
    }

    private static void renderStreamStart(StringBuilder stringBuilder, XMLElement stanza, XMLElement firstInnerElement) {
        try {
            XMLElement features = stanza.getSingleInnerElementsNamed("features");
            if (features != null) {
                XMLElement mechanisms;
                XMLElement starttls = features.getSingleInnerElementsNamed("starttls");
                if (starttls != null) {
                    stringBuilder.append(ELEMENT_SEPARATOR);
                    stringBuilder.append("starttls");
                    XMLElement required = starttls.getSingleInnerElementsNamed("required");
                    if (required != null) {
                        stringBuilder.append("[required]");
                    }
                }
                if ((mechanisms = features.getSingleInnerElementsNamed("mechanisms")) != null) {
                    stringBuilder.append(ELEMENT_SEPARATOR);
                    stringBuilder.append("features.mechanisms[");
                    List list = mechanisms.getInnerElementsNamed("mechanism");
                    if (list != null) {
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            XMLElement element = (XMLElement)it.next();
                            stringBuilder.append(element.getSingleInnerText().getText());
                            if (!it.hasNext()) continue;
                            stringBuilder.append(",");
                        }
                    }
                    stringBuilder.append("]");
                }
            }
        }
        catch (XMLSemanticError xmlSemanticError) {
            stringBuilder.append("*error*");
        }
    }

    private static void renderError(StringBuilder stringBuilder, XMLElement stanza, XMLElement firstInnerElement) {
        if (firstInnerElement == null) {
            stringBuilder.append(ELEMENT_SEPARATOR);
            stringBuilder.append("???");
            return;
        }
        stringBuilder.append(ELEMENT_SEPARATOR);
        stringBuilder.append(firstInnerElement.getName());
    }

    private static void renderPresence(StringBuilder stringBuilder, XMLElement stanza, XMLElement firstInnerElement) {
        DenseStanzaLogRenderer.renderAttribute(stringBuilder, stanza, "type");
        DenseStanzaLogRenderer.renderAttribute(stringBuilder, stanza, "from");
        DenseStanzaLogRenderer.renderAttribute(stringBuilder, stanza, "to");
        try {
            XMLElement caps;
            XMLText statusText;
            XMLElement status;
            XMLText showText;
            XMLElement show = stanza.getSingleInnerElementsNamed("show");
            if (show != null && (showText = show.getSingleInnerText()) != null) {
                stringBuilder.append(ELEMENT_SEPARATOR);
                stringBuilder.append("show").append(EQUALS);
                stringBuilder.append(ATTR_QUOTE).append(showText).append(ATTR_QUOTE);
            }
            if ((status = stanza.getSingleInnerElementsNamed("status")) != null && (statusText = status.getSingleInnerText()) != null) {
                stringBuilder.append(ELEMENT_SEPARATOR);
                stringBuilder.append("status").append(EQUALS);
                stringBuilder.append(ATTR_QUOTE).append(statusText).append(ATTR_QUOTE);
            }
            if ((caps = stanza.getSingleInnerElementsNamed("c")) != null) {
                DenseStanzaLogRenderer.renderAttribute(stringBuilder, caps, "node");
                DenseStanzaLogRenderer.renderAttribute(stringBuilder, caps, "ver");
                DenseStanzaLogRenderer.renderAttribute(stringBuilder, caps, "ext");
            }
        }
        catch (XMLSemanticError xmlSemanticError) {
            stringBuilder.append("*error*");
        }
    }

    private static void renderNamespace(StringBuilder stringBuilder, XMLElement element) {
        String ns = element.getNamespaceURI();
        if (ns != null) {
            DenseStanzaLogRenderer.renderAttributeForm(stringBuilder, "xmlns", ns);
        }
    }

    private static void renderAttribute(StringBuilder stringBuilder, XMLElement element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        if (attributeValue != null) {
            DenseStanzaLogRenderer.renderAttributeForm(stringBuilder, attributeName, attributeValue);
        }
    }

    private static void renderAttributeForm(StringBuilder stringBuilder, String attributeName, String value) {
        stringBuilder.append(ELEMENT_SEPARATOR);
        stringBuilder.append(attributeName).append(EQUALS);
        stringBuilder.append(ATTR_QUOTE).append(value).append(ATTR_QUOTE);
    }

    private static void renderMessage(StringBuilder stringBuilder, XMLElement stanza, XMLElement firstInnerElement) {
        if (firstInnerElement != null) {
            stringBuilder.append(ELEMENT_SEPARATOR);
            stringBuilder.append(firstInnerElement.getName());
            String firstInnerName = firstInnerElement.getName();
            if ("body".equals(firstInnerName)) {
                stringBuilder.append(ELEMENT_SEPARATOR);
                XMLText xmlText = null;
                try {
                    xmlText = firstInnerElement.getSingleInnerText();
                    if (xmlText != null) {
                        stringBuilder.append(xmlText.getText());
                    }
                }
                catch (XMLSemanticError xmlSemanticError) {
                    stringBuilder.append("???");
                }
            }
        }
    }
}

