/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.state.presence;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.state.presence.AbstractBaseCache;
import org.apache.vysper.xmpp.state.presence.PresenceCachingException;

public class SimplePresenceCache
extends AbstractBaseCache {
    private final Map<Entity, Entry> presenceMap = new LinkedHashMap<Entity, Entry>();

    protected void put0(Entity entity, PresenceStanza presenceStanza) {
        this.checkEntry(entity);
        this.presenceMap.remove(entity);
        this.presenceMap.put(entity, new Entry(presenceStanza));
    }

    protected PresenceStanza get0(Entity entity) throws PresenceCachingException {
        this.checkEntry(entity);
        Entry entry = this.presenceMap.get(entity);
        if (entry == null) {
            return null;
        }
        return entry.getPresenceStanza();
    }

    public PresenceStanza getForBareJID(Entity entity) throws PresenceCachingException {
        PresenceStanza latest = null;
        for (Entity key : this.presenceMap.keySet()) {
            if (!key.getBareJID().equals(entity)) continue;
            latest = this.presenceMap.get(key).getPresenceStanza();
        }
        return latest;
    }

    public void remove(Entity entity) {
        this.presenceMap.remove(entity);
    }

    static class Entry {
        protected long timestamp = System.currentTimeMillis();
        protected PresenceStanza presenceStanza;

        Entry(PresenceStanza presenceStanza) {
            this.presenceStanza = presenceStanza;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public PresenceStanza getPresenceStanza() {
            return this.presenceStanza;
        }
    }
}

