/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.base.handler;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.addressing.EntityUtils;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.ReturnErrorToSenderFailureStrategy;
import org.apache.vysper.xmpp.modules.core.base.handler.IQHandler;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManager;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManagerUtils;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayingIQHandler
extends IQHandler {
    final Logger logger = LoggerFactory.getLogger(RelayingIQHandler.class);

    protected Stanza executeIQLogic(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, boolean outboundStanza, SessionContext sessionContext) {
        Entity to = stanza.getTo();
        if (to == null || to.equals(sessionContext.getServerJID())) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.FEATURE_NOT_IMPLEMENTED, stanza, StanzaErrorType.CANCEL, null, null, null);
        }
        RosterManager rosterManager = RosterManagerUtils.getRosterInstance(serverRuntimeContext, sessionContext);
        if (outboundStanza) {
            try {
                boolean toComponent = EntityUtils.isAddressingServerComponent(to, serverRuntimeContext.getServerEnitity());
                Entity from = stanza.getFrom();
                if (from == null || !from.isResourceSet()) {
                    from = new EntityImpl(sessionContext.getInitiatingEntity(), serverRuntimeContext.getResourceRegistry().getUniqueResourceForSession(sessionContext));
                }
                boolean isFromContact = false;
                if (!toComponent) {
                    try {
                        isFromContact = rosterManager.retrieve(from.getBareJID()).getEntry(to.getBareJID()).hasFrom();
                    }
                    catch (Exception e) {
                        isFromContact = false;
                    }
                }
                if (!isFromContact && !toComponent) {
                    return ServerErrorResponses.getStanzaError(StanzaErrorCondition.SERVICE_UNAVAILABLE, stanza, StanzaErrorType.CANCEL, null, null, null);
                }
                Stanza forwardedStanza = (Stanza)StanzaBuilder.createForward(stanza, from, null).build();
                serverRuntimeContext.getStanzaRelay().relay(to, forwardedStanza, new ReturnErrorToSenderFailureStrategy(serverRuntimeContext.getStanzaRelay()));
            }
            catch (DeliveryException e) {}
        } else {
            Entity from = stanza.getFrom();
            boolean fromComponent = from != null && EntityUtils.isAddressingServerComponent(from, serverRuntimeContext.getServerEnitity());
            boolean isToContact = false;
            if (!fromComponent) {
                try {
                    isToContact = rosterManager.retrieve(to.getBareJID()).getEntry(from.getBareJID()).hasTo();
                }
                catch (Exception e) {
                    isToContact = false;
                }
            }
            if (!isToContact && !fromComponent) {
                return ServerErrorResponses.getStanzaError(StanzaErrorCondition.SERVICE_UNAVAILABLE, stanza, StanzaErrorType.CANCEL, null, null, null);
            }
            sessionContext.getResponseWriter().write(stanza);
        }
        return null;
    }
}

