/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.delivery;

import java.util.HashMap;
import java.util.Map;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.StanzaReceiver;
import org.apache.vysper.xmpp.delivery.StanzaReceiverQueue;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.LocalRecipientOfflineException;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.stanza.Stanza;

public class StanzaReceiverRelay
implements StanzaRelay {
    private final Map<Entity, StanzaReceiver> receiverMap = new HashMap<Entity, StanzaReceiver>();
    private boolean exploitFailureStrategy = true;
    private ServerRuntimeContext serverRuntimeContext = null;
    private int countRelayed = 0;
    private int countFailed = 0;
    private int countDelivered = 0;

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void add(Entity receiverID, StanzaReceiver receiver) {
        this.receiverMap.put(receiverID, receiver);
    }

    public void relay(Entity receiver, Stanza stanza, DeliveryFailureStrategy deliveryFailureStrategy) throws DeliveryException {
        ++this.countRelayed;
        if (receiver == null) {
            throw new DeliveryException("receiver cannot be NULL");
        }
        if (this.receiverMap.get(receiver) == null) {
            if (deliveryFailureStrategy != null && this.exploitFailureStrategy) {
                ++this.countFailed;
                deliveryFailureStrategy.process(stanza, null);
            }
            throw new LocalRecipientOfflineException("cannot find receiver " + receiver.getFullQualifiedName());
        }
        ++this.countDelivered;
        this.receiverMap.get(receiver).deliver(stanza);
    }

    public int getCountRelayed() {
        return this.countRelayed;
    }

    public int getCountFailed() {
        return this.countFailed;
    }

    public int getCountDelivered() {
        return this.countDelivered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAll() {
        Map<Entity, StanzaReceiver> map = this.receiverMap;
        synchronized (map) {
            for (StanzaReceiver receiver : this.receiverMap.values()) {
                if (!(receiver instanceof StanzaReceiverQueue)) continue;
                StanzaReceiverQueue stanzaReceiverQueue = (StanzaReceiverQueue)receiver;
                while (stanzaReceiverQueue.getNext() != null) {
                }
            }
        }
        this.countRelayed = 0;
        this.countDelivered = 0;
    }
}

