/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.MUCStanzaBuilder;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler.MUCHandlerHelper;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliation;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Conference;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Occupant;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Role;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Room;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.RoomType;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.IqAdminItem;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.MucUserItem;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.Status;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MUCIqAdminHandler
extends DefaultIQHandler {
    final Logger logger = LoggerFactory.getLogger(MUCIqAdminHandler.class);
    private Conference conference;

    public MUCIqAdminHandler(Conference conference) {
        this.conference = conference;
    }

    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "http://jabber.org/protocol/muc#admin");
    }

    private Entity roomAndNick(Room room, Occupant occupant) {
        return new EntityImpl(room.getJID(), occupant.getNick());
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        this.logger.debug("Received MUC admin stanza");
        Room room = this.conference.findRoom(stanza.getTo());
        Occupant moderator = room.findOccupantByJID(stanza.getFrom());
        if (moderator == null || moderator.getRole() != Role.Moderator) {
            this.logger.debug("Only moderators are allowed to issue admin stanzas");
            return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.AUTH, StanzaErrorCondition.FORBIDDEN);
        }
        try {
            IqAdminItem item;
            XMLElement query = stanza.getSingleInnerElementsNamed("query", "http://jabber.org/protocol/muc#admin");
            XMLElement itemElement = query.getSingleInnerElementsNamed("item", "http://jabber.org/protocol/muc#admin");
            try {
                item = IqAdminItem.getWrapper(itemElement);
            }
            catch (EntityFormatException e) {
                return this.createBadRequestError(stanza, serverRuntimeContext, sessionContext, "Invalid JID");
            }
            if (item.getRole() != null) {
                this.logger.debug("Changing role");
                return this.changeRole(stanza, serverRuntimeContext, sessionContext, item, room, moderator);
            }
            if (item.getAffiliation() != null) {
                this.logger.debug("Changing affiliation");
                return this.changeAffiliation(stanza, serverRuntimeContext, sessionContext, item, room, moderator);
            }
            this.logger.debug("Invalid MUC admin stanza");
            return this.createBadRequestError(stanza, serverRuntimeContext, sessionContext, "Unknown IQ stanza");
        }
        catch (XMLSemanticError e) {
            this.logger.debug("Invalid MUC admin stanza", (Throwable)e);
            return this.createBadRequestError(stanza, serverRuntimeContext, sessionContext, "Invalid IQ stanza");
        }
    }

    private Stanza createBadRequestError(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, String message) {
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.BAD_REQUEST, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.MODIFY, (String)message, (String)this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
    }

    private Stanza changeAffiliation(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, IqAdminItem item, Room room, Occupant moderator) {
        MucUserItem presenceItem;
        Entity from;
        Role newRole;
        if (moderator.getAffiliation() != Affiliation.Admin && moderator.getAffiliation() != Affiliation.Owner) {
            return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
        }
        Entity target = null;
        if (item.getNick() != null) {
            target = room.findOccupantByNick(item.getNick()).getJid();
        } else {
            try {
                if (item.getJid() == null) {
                    return this.createBadRequestError(stanza, serverRuntimeContext, sessionContext, "Missing nick for item");
                }
                target = item.getJid();
            }
            catch (EntityFormatException e) {
                return this.createBadRequestError(stanza, serverRuntimeContext, sessionContext, "Invalid JID");
            }
        }
        Affiliation currentAffiliation = room.getAffiliations().getAffiliation(target);
        Affiliation newAffiliation = item.getAffiliation();
        Occupant targetOccupant = room.findOccupantByJID(target);
        PresenceStanzaType presenceType = null;
        Status status = null;
        if (targetOccupant != null) {
            newRole = targetOccupant.getRole();
            from = this.roomAndNick(room, targetOccupant);
        } else {
            newRole = Role.None;
            from = room.getJID();
        }
        if ((currentAffiliation == Affiliation.Owner || currentAffiliation == Affiliation.Admin) && moderator.getAffiliation() != Affiliation.Owner) {
            return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
        }
        if (newAffiliation == Affiliation.None && room.isRoomType(RoomType.MembersOnly) || newAffiliation == Affiliation.Outcast) {
            if (newAffiliation == Affiliation.Outcast && targetOccupant.getAffiliation().compareTo(moderator.getAffiliation()) < 0) {
                return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
            }
            if (targetOccupant != null) {
                room.removeOccupant(target);
            }
            presenceType = PresenceStanzaType.UNAVAILABLE;
            status = newAffiliation == Affiliation.Outcast ? new Status(Status.StatusCode.BEEN_BANNED) : new Status(Status.StatusCode.REMOVED_BY_AFFILIATION);
            newRole = Role.None;
            presenceItem = new MucUserItem(newAffiliation, newRole);
            Stanza presenceToFormerMember = MUCStanzaBuilder.createPresenceStanza(from, targetOccupant.getJid(), presenceType, "http://jabber.org/protocol/muc#user", presenceItem, status);
            this.relayStanza(targetOccupant.getJid(), presenceToFormerMember, serverRuntimeContext);
        } else if ((newAffiliation == Affiliation.Owner || newAffiliation == Affiliation.Admin) && moderator.getAffiliation() != Affiliation.Owner) {
            return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
        }
        room.getAffiliations().add(target, newAffiliation);
        if (targetOccupant != null) {
            presenceItem = new MucUserItem(newAffiliation, newRole);
            for (Occupant occupant : room.getOccupants()) {
                Stanza presenceToRemaining = MUCStanzaBuilder.createPresenceStanza(from, occupant.getJid(), presenceType, "http://jabber.org/protocol/muc#user", presenceItem, status);
                this.relayStanza(occupant.getJid(), presenceToRemaining, serverRuntimeContext);
            }
        } else {
            room.getAffiliations().add(target, newAffiliation);
            presenceItem = new MucUserItem(target, null, newAffiliation, Role.None);
            for (Occupant occupant : room.getOccupants()) {
                StanzaBuilder builder = MUCStanzaBuilder.createMessageStanza((Entity)room.getJID(), (Entity)occupant.getJid(), null, null);
                builder.addPreparedElement((XMLElement)presenceItem);
                this.relayStanza(occupant.getJid(), (Stanza)builder.build(), serverRuntimeContext);
            }
        }
        return (Stanza)StanzaBuilder.createIQStanza((Entity)stanza.getTo(), (Entity)stanza.getFrom(), (IQStanzaType)IQStanzaType.RESULT, (String)stanza.getID()).build();
    }

    private Stanza changeRole(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, IqAdminItem item, Room room, Occupant moderator) {
        Occupant target = null;
        if (item.getNick() == null) {
            return this.createBadRequestError(stanza, serverRuntimeContext, sessionContext, "Missing nick for item");
        }
        target = room.findOccupantByNick(item.getNick());
        Role newRole = item.getRole();
        if (moderator.getJid().equals(target.getJid())) {
            return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.CONFLICT);
        }
        if (newRole == Role.None) {
            if (target.getAffiliation().compareTo(moderator.getAffiliation()) < 0) {
                return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
            }
        } else if (newRole == Role.Visitor) {
            if (target.getAffiliation() == Affiliation.Admin || target.getAffiliation() == Affiliation.Owner) {
                return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
            }
        } else if (newRole == Role.Participant) {
            if (target.getRole() == Role.Moderator) {
                if (moderator.getAffiliation() != Affiliation.Admin && moderator.getAffiliation() != Affiliation.Owner) {
                    return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
                }
                if (target.getAffiliation() == Affiliation.Admin || target.getAffiliation() == Affiliation.Owner) {
                    return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
                }
            }
        } else if (newRole == Role.Moderator && moderator.getAffiliation() != Affiliation.Admin && moderator.getAffiliation() != Affiliation.Owner) {
            return MUCHandlerHelper.createErrorReply((Stanza)stanza, StanzaErrorType.CANCEL, StanzaErrorCondition.NOT_ALLOWED);
        }
        target.setRole(newRole);
        if (newRole == Role.None) {
            room.removeOccupant(target.getJid());
        }
        Entity targetInRoom = this.roomAndNick(room, target);
        Status status = null;
        if (newRole == Role.None) {
            status = new Status(Status.StatusCode.BEEN_KICKED);
            Stanza presenceToKicked = MUCStanzaBuilder.createPresenceStanza(targetInRoom, target.getJid(), PresenceStanzaType.UNAVAILABLE, "http://jabber.org/protocol/muc#user", new MucUserItem(Affiliation.None, Role.None), status);
            this.relayStanza(target.getJid(), presenceToKicked, serverRuntimeContext);
        }
        PresenceStanzaType availType = newRole == Role.None ? PresenceStanzaType.UNAVAILABLE : null;
        MucUserItem presenceItem = new MucUserItem(target.getAffiliation(), newRole);
        for (Occupant occupant : room.getOccupants()) {
            Stanza presenceToRemaining = MUCStanzaBuilder.createPresenceStanza(targetInRoom, occupant.getJid(), availType, "http://jabber.org/protocol/muc#user", presenceItem, status);
            this.relayStanza(occupant.getJid(), presenceToRemaining, serverRuntimeContext);
        }
        return (Stanza)StanzaBuilder.createIQStanza((Entity)stanza.getTo(), (Entity)stanza.getFrom(), (IQStanzaType)IQStanzaType.RESULT, (String)stanza.getID()).build();
    }

    protected void relayStanza(Entity receiver, Stanza stanza, ServerRuntimeContext serverRuntimeContext) {
        try {
            serverRuntimeContext.getStanzaRelay().relay(receiver, stanza, (DeliveryFailureStrategy)new IgnoreFailureStrategy());
        }
        catch (DeliveryException e) {
            this.logger.warn("presence relaying failed ", (Throwable)e);
        }
    }
}

