/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

class PathConstraint
extends ValueConstraint {
    final Path path;
    final boolean deep;

    PathConstraint(String definition, NamePathResolver resolver) throws InvalidConstraintException {
        super(definition);
        this.deep = definition.endsWith("*");
        if (this.deep) {
            definition = definition.substring(0, definition.length() - 1);
        }
        try {
            this.path = resolver.getQPath(definition);
        }
        catch (NameException e) {
            String msg = "invalid path expression specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, e);
        }
        catch (NamespaceException e) {
            String msg = "invalid path expression specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, e);
        }
    }

    public String getDefinition(NamePathResolver resolver) {
        try {
            String p = resolver.getJCRPath(this.path);
            if (!this.deep) {
                return p;
            }
            if (this.path.denotesRoot()) {
                return p + "*";
            }
            return p + "/*";
        }
        catch (NamespaceException e) {
            return this.definition;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void check(InternalValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        switch (value.getType()) {
            case 8: {
                Path p1;
                Path p0;
                Path p = value.getPath();
                try {
                    p0 = this.path.getNormalizedPath();
                    p1 = p.getNormalizedPath();
                }
                catch (MalformedPathException e) {
                    throw new ConstraintViolationException("path not valid: " + (Object)((Object)e));
                }
                if (this.deep) {
                    try {
                        if (p0.isAncestorOf(p1)) return;
                        throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.definition + "'");
                    }
                    catch (MalformedPathException mpe) {
                        throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.definition + "'");
                    }
                }
                if (p0.equals(p1)) return;
                throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.definition + "'");
            }
        }
        String msg = "PATH constraint can not be applied to value of type: " + PropertyType.nameFromValue((int)value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

