/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.sax.impl;

import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.vysper.xml.sax.impl.Attribute;
import org.apache.vysper.xml.sax.impl.DefaultAttributes;
import org.apache.vysper.xml.sax.impl.ParserNamespaceResolver;
import org.apache.vysper.xml.sax.impl.XMLTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParser
implements XMLTokenizer.TokenListener {
    private Logger log = LoggerFactory.getLogger(XMLParser.class);
    private static final String nameStartChar = ":A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";
    private static final String nameChar = ":A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD-\\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040";
    public static final Pattern NAME_PATTERN = Pattern.compile("^[:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD][:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD-\\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]*$");
    public static final Pattern NAME_PREFIX_PATTERN = Pattern.compile("^xml", 2);
    public static final Pattern UNESCAPE_UNICODE_PATTERN = Pattern.compile("\\&\\#(x?)(.+);");
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private ParserNamespaceResolver nsResolver = new ParserNamespaceResolver();
    private XMLTokenizer tokenizer;
    private State state = State.START;
    private String qname;
    private Map<String, String> attributes;
    private String attributeName;
    private Stack<String> elements = new Stack();
    private boolean sentStartDocument = false;
    private boolean reportNsAttributes = false;
    private boolean commentsAllowed = true;
    private boolean restartsAllowed = false;
    private String restartQname = null;

    public XMLParser(ContentHandler contentHandler, ErrorHandler errorHandler, Map<String, Boolean> features, Map<String, Object> properties) {
        this.contentHandler = contentHandler;
        this.errorHandler = errorHandler;
        this.commentsAllowed = this.feature(features, "http://mina.apache.org/vysper/features/comments-allowed", true);
        this.reportNsAttributes = this.feature(features, "http://xml.org/sax/features/namespace-prefixes", false);
        this.reportNsAttributes = this.feature(features, "http://xml.org/sax/features/namespace-prefixes", false);
        this.restartsAllowed = this.feature(features, "http://mina.apache.org/vysper/features/restart-allowed", false);
        this.restartQname = (String)properties.get("http://mina.apache.org/vysper/properties/restart-qname");
        this.tokenizer = new XMLTokenizer(this);
    }

    private boolean feature(Map<String, Boolean> features, String name, boolean defaultValue) {
        if (features.containsKey(name)) {
            return features.get(name);
        }
        return defaultValue;
    }

    public void parse(IoBuffer byteBuffer, CharsetDecoder charsetDecoder) throws SAXException {
        if (this.state == State.CLOSED) {
            throw new SAXException("Parser is closed");
        }
        try {
            this.tokenizer.parse(byteBuffer, charsetDecoder);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.fatalError(e.getMessage());
        }
    }

    @Override
    public void token(char c, String token) throws SAXException {
        if (this.log.isTraceEnabled()) {
            String s = token == null ? Character.toString(c) : token;
            this.log.trace("Parser got token {} in state {}", (Object)s, (Object)this.state);
        }
        switch (this.state) {
            case START: {
                if (c == '<') {
                    this.state = State.IN_TAG;
                    this.attributes = new HashMap<String, String>();
                    break;
                }
                this.characters(token);
                break;
            }
            case IN_TAG: {
                if (c == '/') {
                    this.state = State.IN_END_TAG;
                    break;
                }
                if (c == '?') {
                    this.state = State.IN_DECLARATION;
                    this.xmlDeclaration();
                    break;
                }
                if (c == '!') {
                    if (this.commentsAllowed) {
                        this.state = State.AFTER_COMMENT_BANG;
                        break;
                    }
                    this.fatalError("Comments not allowed");
                    return;
                }
                if (token != null && this.isValidName(token)) {
                    this.qname = token;
                    this.state = State.AFTER_START_NAME;
                    break;
                }
                if (token != null) {
                    this.fatalError("Invalid element name: " + this.qname);
                } else {
                    this.fatalError("Not well-formed start tag");
                }
                return;
            }
            case IN_END_TAG: {
                this.qname = token;
                this.state = State.AFTER_END_NAME;
                break;
            }
            case AFTER_START_NAME: {
                if (c == '>') {
                    if (this.state == State.AFTER_START_NAME) {
                        this.startElement();
                        this.state = State.START;
                        this.attributes = null;
                        break;
                    }
                    if (this.state != State.AFTER_END_NAME) break;
                    this.state = State.START;
                    this.endElement();
                    break;
                }
                if (c == '/') {
                    this.state = State.IN_EMPTY_TAG;
                    break;
                }
                this.attributeName = token;
                this.state = State.AFTER_ATTRIBUTE_NAME;
                break;
            }
            case AFTER_ATTRIBUTE_NAME: {
                if (c == '=') {
                    this.state = State.AFTER_ATTRIBUTE_EQUALS;
                    break;
                }
                this.fatalError("Not wellformed");
                break;
            }
            case AFTER_ATTRIBUTE_EQUALS: {
                if (c != '\"' && c != '\'') break;
                this.state = State.AFTER_ATTRIBUTE_FIRST_QUOTE;
                break;
            }
            case AFTER_ATTRIBUTE_FIRST_QUOTE: {
                this.attributes.put(this.attributeName, this.unescape(token));
                this.state = State.AFTER_ATTRIBUTE_VALUE;
                break;
            }
            case AFTER_ATTRIBUTE_VALUE: {
                if (c == '\"' || c == '\'') {
                    this.state = State.AFTER_START_NAME;
                    break;
                }
                this.fatalError("Not wellformed");
                break;
            }
            case AFTER_END_NAME: {
                if (c != '>') break;
                this.state = State.START;
                this.endElement();
                break;
            }
            case IN_EMPTY_TAG: {
                if (c != '>') break;
                this.startElement();
                this.attributes = null;
                if (this.state == State.CLOSED) break;
                this.state = State.START;
                this.endElement();
                break;
            }
            case AFTER_COMMENT_BANG: {
                if (c == '-') {
                    this.state = State.AFTER_COMMENT_DASH1;
                    break;
                }
                this.fatalError("Comment not wellformed");
                return;
            }
            case AFTER_COMMENT_DASH1: {
                if (c == '-') {
                    this.state = State.AFTER_COMMENT_DASH2;
                    break;
                }
                this.fatalError("Comment not wellformed");
                return;
            }
            case AFTER_COMMENT_DASH2: {
                if (c == '-') {
                    this.state = State.AFTER_COMMENT_CLOSING_DASH1;
                    break;
                }
                this.state = State.AFTER_COMMENT;
                break;
            }
            case AFTER_COMMENT: {
                if (c == '-') {
                    this.state = State.AFTER_COMMENT_CLOSING_DASH1;
                    break;
                }
                if (c != '>') break;
                this.fatalError("Comment not wellformed");
                return;
            }
            case AFTER_COMMENT_CLOSING_DASH1: {
                if (c == '-') {
                    this.state = State.AFTER_COMMENT_CLOSING_DASH2;
                    break;
                }
                this.fatalError("Comment not wellformed");
                return;
            }
            case AFTER_COMMENT_CLOSING_DASH2: {
                if (c == '>') {
                    this.state = State.START;
                    break;
                }
                this.fatalError("Comment not wellformed");
                return;
            }
            case IN_DECLARATION: {
                if (c != '>') break;
                this.state = State.START;
            }
        }
    }

    private void characters(String s) throws SAXException {
        if (!this.elements.isEmpty()) {
            String unescaped = this.unescape(s);
            this.log.trace("Parser emitting characters \"{}\"", (Object)unescaped);
            this.contentHandler.characters(unescaped.toCharArray(), 0, unescaped.length());
        } else if (s.trim().length() > 0) {
            this.startDocument();
            this.fatalError("Text only allowed in element");
        } else {
            this.startDocument();
        }
    }

    private boolean isValidName(String name) {
        return NAME_PATTERN.matcher(name).find() && !NAME_PREFIX_PATTERN.matcher(name).find();
    }

    private boolean needsRestart() {
        return this.elements.size() > 0;
    }

    private void restart() {
        this.log.trace("Restarting XML stream");
        this.elements.clear();
        this.nsResolver = new ParserNamespaceResolver();
        this.sentStartDocument = false;
        this.tokenizer.restart();
    }

    private void xmlDeclaration() {
        if (this.needsRestart() && this.restartsAllowed) {
            this.restart();
        }
    }

    private void startDocument() throws SAXException {
        if (!this.sentStartDocument) {
            this.contentHandler.startDocument();
            this.sentStartDocument = true;
        }
    }

    private void startElement() throws SAXException {
        this.log.trace("StartElement {}", (Object)this.qname);
        if (this.restartsAllowed && this.needsRestart() && this.qname.equals(this.restartQname)) {
            this.restart();
        }
        if (this.elements.isEmpty()) {
            this.startDocument();
        }
        HashMap<String, String> nsDeclarations = new HashMap<String, String>();
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            if (attribute.getKey().equals("xmlns")) {
                nsDeclarations.put("", attribute.getValue());
                continue;
            }
            if (!attribute.getKey().startsWith("xmlns:")) continue;
            nsDeclarations.put(attribute.getKey().substring(6), attribute.getValue());
        }
        this.nsResolver.push(nsDeclarations);
        ArrayList<Attribute> nonNsAttributes = new ArrayList<Attribute>();
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            String attUri;
            String attQname = attribute.getKey();
            if (this.reportNsAttributes) {
                nonNsAttributes.add(new Attribute(attQname, null, attQname, attribute.getValue()));
                continue;
            }
            if (attQname.equals("xmlns") || attQname.startsWith("xmlns:")) continue;
            String attLocalName = this.extractLocalName(attQname);
            String attPrefix = this.extractNsPrefix(attQname);
            if (attPrefix.length() > 0) {
                attUri = this.nsResolver.resolveUri(attPrefix);
                if (attUri == null) {
                    if (attPrefix.length() > 0) {
                        this.fatalError("Undeclared namespace prefix: " + attPrefix);
                        return;
                    }
                    attUri = "";
                }
            } else {
                attUri = "";
            }
            nonNsAttributes.add(new Attribute(attLocalName, attUri, attQname, attribute.getValue()));
        }
        String prefix = this.extractNsPrefix(this.qname);
        String uri = this.nsResolver.resolveUri(prefix);
        if (uri == null) {
            if (prefix.length() > 0) {
                this.fatalError("Undeclared namespace prefix: " + prefix);
                return;
            }
            uri = "";
        }
        String localName = this.extractLocalName(this.qname);
        this.elements.add(this.fullyQualifiedName(uri, this.qname));
        this.contentHandler.startElement(uri, localName, this.qname, new DefaultAttributes(nonNsAttributes));
    }

    private String extractLocalName(String qname) {
        int index = qname.indexOf(58);
        if (index > -1) {
            return qname.substring(index + 1);
        }
        return qname;
    }

    private String extractNsPrefix(String qname) {
        int index = qname.indexOf(58);
        if (index > -1) {
            return qname.substring(0, index);
        }
        return "";
    }

    private String fullyQualifiedName(String uri, String qname) {
        return "{" + uri + "}" + qname;
    }

    private void endElement() throws SAXException {
        this.log.trace("EndElement {}", (Object)this.qname);
        if (this.state == State.CLOSED) {
            return;
        }
        String prefix = this.extractNsPrefix(this.qname);
        String uri = this.nsResolver.resolveUri(prefix);
        if (uri == null) {
            if (prefix.length() > 0) {
                this.fatalError("Undeclared namespace prefix: " + prefix);
                return;
            }
            uri = "";
        }
        this.nsResolver.pop();
        String localName = this.extractLocalName(this.qname);
        String fqn = this.elements.pop();
        if (fqn.equals(this.fullyQualifiedName(uri, this.qname))) {
            this.contentHandler.endElement(uri, localName, this.qname);
            if (this.elements.isEmpty()) {
                this.contentHandler.endDocument();
                this.state = State.CLOSED;
            }
        } else {
            this.fatalError("Invalid element name " + this.qname);
        }
    }

    private void fatalError(String message) throws SAXException {
        this.log.debug("Fatal error: {}", (Object)message);
        this.state = State.CLOSED;
        this.tokenizer.close();
        this.startDocument();
        this.errorHandler.fatalError(new SAXParseException(message, null));
    }

    private String unescape(String s) {
        s = s.replace("&amp;", "&").replace("&gt;", ">").replace("&lt;", "<").replace("&apos;", "'").replace("&quot;", "\"");
        StringBuffer sb = new StringBuffer();
        Matcher matcher = UNESCAPE_UNICODE_PATTERN.matcher(s);
        int end = 0;
        while (matcher.find()) {
            boolean isHex = matcher.group(1).equals("x");
            String unicodeCode = matcher.group(2);
            int base = isHex ? 16 : 10;
            int i = Integer.valueOf(unicodeCode, base);
            char[] c = Character.toChars(i);
            sb.append(s.substring(end, matcher.start()));
            end = matcher.end();
            sb.append(c);
        }
        sb.append(s.substring(end, s.length()));
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START,
        IN_TAG,
        IN_DECLARATION,
        IN_END_TAG,
        AFTER_START_NAME,
        AFTER_END_NAME,
        IN_EMPTY_TAG,
        AFTER_ATTRIBUTE_NAME,
        AFTER_ATTRIBUTE_EQUALS,
        AFTER_ATTRIBUTE_FIRST_QUOTE,
        AFTER_ATTRIBUTE_VALUE,
        AFTER_COMMENT_BANG,
        AFTER_COMMENT_DASH1,
        AFTER_COMMENT_DASH2,
        AFTER_COMMENT,
        AFTER_COMMENT_CLOSING_DASH1,
        AFTER_COMMENT_CLOSING_DASH2,
        AFTER_COMMENT_ENDING_DASH1,
        AFTER_COMMENT_ENDING_DASH2,
        CLOSED;

    }
}

