/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.DrawingRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        this.processEvents(req, in);
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException, HSSFUserException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        return this.abortableProcessEvents(req, in);
    }

    public void processEvents(HSSFRequest req, InputStream in) throws IOException {
        try {
            this.genericProcessEvents(req, new RecordInputStream(in));
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest req, InputStream in) throws IOException, HSSFUserException {
        return this.genericProcessEvents(req, new RecordInputStream(in));
    }

    protected short genericProcessEvents(HSSFRequest req, RecordInputStream in) throws IOException, HSSFUserException {
        short userCode;
        block12: {
            userCode = 0;
            short sid = 0;
            Record rec = null;
            Record lastRec = null;
            DrawingRecord lastDrawingRecord = new DrawingRecord();
            while (in.hasNextRecord()) {
                Record[] recs;
                in.nextRecord();
                sid = in.getSid();
                if (sid == 0) break;
                if (rec != null && sid != 60 && (userCode = req.processRecord(rec)) != 0) break block12;
                if (sid != 60) {
                    recs = RecordFactory.createRecord(in);
                    if (recs.length > 1) {
                        for (int k = 0; k < recs.length - 1; ++k) {
                            userCode = req.processRecord(recs[k]);
                            if (userCode == 0) {
                                continue;
                            }
                            break block12;
                        }
                    }
                    rec = recs[recs.length - 1];
                } else {
                    recs = RecordFactory.createRecord(in);
                    ContinueRecord crec = (ContinueRecord)recs[0];
                    if (lastRec instanceof ObjRecord || lastRec instanceof TextObjectRecord) {
                        lastDrawingRecord.processContinueRecord(crec.getData());
                        rec = lastDrawingRecord;
                    } else if (lastRec instanceof DrawingGroupRecord) {
                        ((DrawingGroupRecord)lastRec).processContinueRecord(crec.getData());
                        rec = lastRec;
                    } else if (!(rec instanceof UnknownRecord)) {
                        throw new RecordFormatException("Records should handle ContinueRecord internally. Should not see this exception");
                    }
                }
                lastRec = rec;
                if (!(rec instanceof DrawingRecord)) continue;
                lastDrawingRecord = (DrawingRecord)rec;
            }
            if (rec == null || (userCode = req.processRecord(rec)) == 0) {
                // empty if block
            }
        }
        return userCode;
    }
}

