/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;

public class SetFactoryBean
extends AbstractFactoryBean {
    private Set sourceSet;
    private Class targetSetClass;

    public void setSourceSet(Set sourceSet) {
        this.sourceSet = sourceSet;
    }

    public void setTargetSetClass(Class targetSetClass) {
        if (targetSetClass == null) {
            throw new IllegalArgumentException("'targetSetClass' must not be null");
        }
        if (!Set.class.isAssignableFrom(targetSetClass)) {
            throw new IllegalArgumentException("'targetSetClass' must implement [java.util.Set]");
        }
        this.targetSetClass = targetSetClass;
    }

    public Class getObjectType() {
        return Set.class;
    }

    protected Object createInstance() {
        if (this.sourceSet == null) {
            throw new IllegalArgumentException("'sourceSet' is required");
        }
        LinkedHashSet<Object> result = null;
        result = this.targetSetClass != null ? (LinkedHashSet<Object>)BeanUtils.instantiateClass(this.targetSetClass) : new LinkedHashSet<Object>(this.sourceSet.size());
        Class valueType = null;
        if (this.targetSetClass != null && JdkVersion.isAtLeastJava15()) {
            valueType = GenericCollectionTypeResolver.getCollectionType((Class)this.targetSetClass);
        }
        if (valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            Iterator it = this.sourceSet.iterator();
            while (it.hasNext()) {
                result.add(converter.convertIfNecessary(it.next(), valueType));
            }
        } else {
            result.addAll(this.sourceSet);
        }
        return result;
    }
}

