/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.BytesRef;

final class MockPayloadFilter
extends TokenFilter {
    String fieldName;
    int pos;
    int i;
    final PositionIncrementAttribute posIncrAttr;
    final PayloadAttribute payloadAttr;
    final CharTermAttribute termAttr;

    public MockPayloadFilter(TokenStream input, String fieldName) {
        super(input);
        this.fieldName = fieldName;
        this.pos = 0;
        this.i = 0;
        this.posIncrAttr = (PositionIncrementAttribute)input.addAttribute(PositionIncrementAttribute.class);
        this.payloadAttr = (PayloadAttribute)input.addAttribute(PayloadAttribute.class);
        this.termAttr = (CharTermAttribute)input.addAttribute(CharTermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.payloadAttr.setPayload(new BytesRef(("pos: " + this.pos).getBytes(StandardCharsets.UTF_8)));
            int posIncr = this.pos == 0 || this.i % 2 == 1 ? 1 : 0;
            this.posIncrAttr.setPositionIncrement(posIncr);
            this.pos += posIncr;
            ++this.i;
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.i = 0;
        this.pos = 0;
    }
}

