/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.util.inifile.IniFile;
import org.apache.lucene.luke.app.desktop.util.inifile.SimpleIniFile;
import org.apache.lucene.store.FSDirectory;

public final class PreferencesImpl
implements Preferences {
    private static final String CONFIG_DIR = System.getProperty("user.home") + FileSystems.getDefault().getSeparator() + ".luke.d";
    private static final String INIT_FILE = "luke.ini";
    private static final String HISTORY_FILE = "history";
    private static final int MAX_HISTORY = 10;
    private final IniFile ini = new SimpleIniFile();
    private final List<String> history = new ArrayList<String>();

    public PreferencesImpl() throws IOException {
        Path confDir = FileSystems.getDefault().getPath(CONFIG_DIR, new String[0]);
        if (!Files.exists(confDir, new LinkOption[0])) {
            Files.createDirectory(confDir, new FileAttribute[0]);
        }
        if (Files.exists(this.iniFile(), new LinkOption[0])) {
            this.ini.load(this.iniFile());
        } else {
            this.ini.store(this.iniFile());
        }
        Path histFile = this.historyFile();
        if (Files.exists(histFile, new LinkOption[0])) {
            List<String> allHistory = Files.readAllLines(histFile);
            this.history.addAll(allHistory.subList(0, Math.min(10, allHistory.size())));
        }
    }

    @Override
    public List<String> getHistory() {
        return this.history;
    }

    @Override
    public void addHistory(String indexPath) throws IOException {
        if (this.history.indexOf(indexPath) >= 0) {
            this.history.remove(indexPath);
        }
        this.history.add(0, indexPath);
        this.saveHistory();
    }

    @Override
    public void removeHistory(String indexPath) throws IOException {
        if (this.history.contains(indexPath)) {
            this.history.remove(indexPath);
            this.saveHistory();
        }
    }

    private void saveHistory() throws IOException {
        Files.write(this.historyFile(), this.history, new OpenOption[0]);
    }

    private Path historyFile() {
        return FileSystems.getDefault().getPath(CONFIG_DIR, HISTORY_FILE);
    }

    @Override
    public Preferences.ColorTheme getColorTheme() {
        String theme = this.ini.getString("settings", "theme");
        return theme == null ? Preferences.ColorTheme.GRAY : Preferences.ColorTheme.valueOf(theme);
    }

    @Override
    public void setColorTheme(Preferences.ColorTheme theme) throws IOException {
        this.ini.put("settings", "theme", theme.name());
        this.ini.store(this.iniFile());
    }

    @Override
    public boolean isReadOnly() {
        Boolean readOnly = this.ini.getBoolean("opener", "readOnly");
        return readOnly == null ? false : readOnly;
    }

    @Override
    public String getDirImpl() {
        String dirImpl = this.ini.getString("opener", "dirImpl");
        return dirImpl == null ? FSDirectory.class.getName() : dirImpl;
    }

    @Override
    public boolean isNoReader() {
        Boolean noReader = this.ini.getBoolean("opener", "noReader");
        return noReader == null ? false : noReader;
    }

    @Override
    public boolean isUseCompound() {
        Boolean useCompound = this.ini.getBoolean("opener", "useCompound");
        return useCompound == null ? false : useCompound;
    }

    @Override
    public boolean isKeepAllCommits() {
        Boolean keepAllCommits = this.ini.getBoolean("opener", "keepAllCommits");
        return keepAllCommits == null ? false : keepAllCommits;
    }

    @Override
    public void setIndexOpenerPrefs(boolean readOnly, String dirImpl, boolean noReader, boolean useCompound, boolean keepAllCommits) throws IOException {
        this.ini.put("opener", "readOnly", readOnly);
        this.ini.put("opener", "dirImpl", dirImpl);
        this.ini.put("opener", "noReader", noReader);
        this.ini.put("opener", "useCompound", useCompound);
        this.ini.put("opener", "keepAllCommits", keepAllCommits);
        this.ini.store(this.iniFile());
    }

    private Path iniFile() {
        return FileSystems.getDefault().getPath(CONFIG_DIR, INIT_FILE);
    }
}

