/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kotlin;

import java.util.Collections;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.SimpleLoggerLruCache;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u001a\u0012\u0010\n\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0002\u001a\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\r\u001a\u0012\u0010\u0012\u001a\u00020\u00132\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\rH\u0007\u001a$\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0002\"\b\b\u0000\u0010\u0007*\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u0004\"\n\b\u0000\u0010\u0007\u0018\u0001*\u00020\u0017*\u0002H\u0007H\u0086\b\u00a2\u0006\u0002\u0010\t\"^\u0010\u0000\u001aR\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0003*\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u0004 \u0003*(\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0003*\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00050\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0006\u001a\u00020\u0004\"\u0006\b\u0000\u0010\u0007\u0018\u0001*\u0002H\u00078\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"loggerCache", "", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/kotlin/KotlinLogger;", "", "logger", "T", "getLogger", "(Ljava/lang/Object;)Lorg/apache/logging/log4j/kotlin/KotlinLogger;", "cachedLoggerOf", "ofClass", "contextName", "", "context", "Lkotlin/Function0;", "", "name", "loggerDelegateOf", "Lorg/apache/logging/log4j/spi/ExtendedLogger;", "loggerOf", "namedLogger", "unwrapCompanionClass", "", "log4j-api-kotlin"})
public final class LoggingFactoryKt {
    private static final Map<Class<?>, KotlinLogger> loggerCache = Collections.synchronizedMap(new SimpleLoggerLruCache(100));

    public static final /* synthetic */ <T> KotlinLogger logger(T $this$logger) {
        Intrinsics.checkNotNullParameter($this$logger, (String)"<this>");
        boolean $i$f$logger = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return LoggingFactoryKt.loggerOf(Object.class);
    }

    public static final /* synthetic */ <T> KotlinLogger getLogger(T $this$logger) {
        boolean $i$f$getLogger = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return LoggingFactoryKt.cachedLoggerOf(Object.class);
    }

    @NotNull
    public static final KotlinLogger logger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ExtendedLogger extendedLogger = LogManager.getContext((boolean)false).getLogger(name);
        Intrinsics.checkNotNullExpressionValue((Object)extendedLogger, (String)"getContext(false).getLogger(name)");
        return new KotlinLogger(extendedLogger);
    }

    @NotNull
    public static final String contextName(@NotNull Function0<Unit> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        String $this$contextName_u24lambda_u2d0 = context.getClass().getName();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$contextName_u24lambda_u2d0, (String)"");
        String string = StringsKt.contains$default((CharSequence)$this$contextName_u24lambda_u2d0, (CharSequence)"Kt$", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)$this$contextName_u24lambda_u2d0, (String)"Kt$", null, (int)2, null) : (StringsKt.contains$default((CharSequence)$this$contextName_u24lambda_u2d0, (CharSequence)"$", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)$this$contextName_u24lambda_u2d0, (String)"$", null, (int)2, null) : $this$contextName_u24lambda_u2d0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(context::class.java\u2026\")\n    else -> this\n  }\n}");
        return string;
    }

    @Deprecated(message="Replaced with logger(name)", replaceWith=@ReplaceWith(expression="logger", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final KotlinLogger namedLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ExtendedLogger extendedLogger = LogManager.getContext((boolean)false).getLogger(name);
        Intrinsics.checkNotNullExpressionValue((Object)extendedLogger, (String)"getContext(false).getLogger(name)");
        return new KotlinLogger(extendedLogger);
    }

    @NotNull
    public static final ExtendedLogger loggerDelegateOf(@NotNull Class<?> ofClass) {
        Intrinsics.checkNotNullParameter(ofClass, (String)"ofClass");
        ExtendedLogger extendedLogger = LogManager.getContext((ClassLoader)ofClass.getClassLoader(), (boolean)false).getLogger(LoggingFactoryKt.unwrapCompanionClass(ofClass).getName());
        Intrinsics.checkNotNullExpressionValue((Object)extendedLogger, (String)"getContext(ofClass.class\u2026anionClass(ofClass).name)");
        return extendedLogger;
    }

    @NotNull
    public static final KotlinLogger loggerOf(@NotNull Class<?> ofClass) {
        Intrinsics.checkNotNullParameter(ofClass, (String)"ofClass");
        return new KotlinLogger(LoggingFactoryKt.loggerDelegateOf(ofClass));
    }

    @NotNull
    public static final KotlinLogger cachedLoggerOf(@NotNull Class<?> ofClass) {
        KotlinLogger kotlinLogger;
        Intrinsics.checkNotNullParameter(ofClass, (String)"ofClass");
        Map<Class<?>, KotlinLogger> map = loggerCache;
        Intrinsics.checkNotNullExpressionValue(map, (String)"loggerCache");
        Map<Class<?>, KotlinLogger> $this$getOrPut$iv = map;
        boolean $i$f$getOrPut = false;
        KotlinLogger value$iv = $this$getOrPut$iv.get(ofClass);
        if (value$iv == null) {
            boolean bl = false;
            KotlinLogger answer$iv = LoggingFactoryKt.loggerOf(ofClass);
            $this$getOrPut$iv.put(ofClass, answer$iv);
            kotlinLogger = answer$iv;
        } else {
            kotlinLogger = value$iv;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLogger, (String)"loggerCache.getOrPut(ofC\u2026ss) { loggerOf(ofClass) }");
        return kotlinLogger;
    }

    private static final <T> Class<?> unwrapCompanionClass(Class<T> ofClass) {
        Class<Object> clazz;
        KClass kClass = ofClass.getEnclosingClass();
        if (Intrinsics.areEqual(kClass != null && (kClass = JvmClassMappingKt.getKotlinClass(kClass)) != null && (kClass = KClasses.getCompanionObject((KClass)kClass)) != null ? JvmClassMappingKt.getJavaClass((KClass)kClass) : null, ofClass)) {
            Class<?> clazz2 = ofClass.getEnclosingClass();
            clazz = clazz2;
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"{\n    ofClass.enclosingClass\n  }");
        } else {
            clazz = ofClass;
        }
        return clazz;
    }
}

