/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.color;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.color.Colorizer;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.rule.ColorRule;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class RuleColorizer
implements Colorizer {
    private Map rules;
    private final PropertyChangeSupport colorChangeSupport = new PropertyChangeSupport(this);
    private Map defaultRules = new HashMap();
    private String currentRuleSet = "Default";
    private Rule findRule;
    private Rule loggerRule;
    private static final String COLORS_EXTENSION = ".colors";
    private final Color WARN_DEFAULT_COLOR = new Color(255, 255, 153);
    private final Color FATAL_OR_ERROR_DEFAULT_COLOR = new Color(255, 153, 153);
    private final Color MARKER_DEFAULT_COLOR = new Color(153, 255, 153);
    private final String DEFAULT_WARN_EXPRESSION = "level == WARN";
    private final String DEFAULT_FATAL_ERROR_EXCEPTION_EXPRESSION = "level == FATAL || level == ERROR || exception exists";
    private final String DEFAULT_MARKER_EXPRESSION = "prop.marker exists";

    public RuleColorizer() {
        ArrayList<ColorRule> rulesList = new ArrayList<ColorRule>();
        String expression = "level == FATAL || level == ERROR || exception exists";
        rulesList.add(new ColorRule(expression, ExpressionRule.getRule(expression), this.FATAL_OR_ERROR_DEFAULT_COLOR, Color.black));
        expression = "level == WARN";
        rulesList.add(new ColorRule(expression, ExpressionRule.getRule(expression), this.WARN_DEFAULT_COLOR, Color.black));
        expression = "prop.marker exists";
        rulesList.add(new ColorRule(expression, ExpressionRule.getRule(expression), this.MARKER_DEFAULT_COLOR, Color.black));
        this.defaultRules.put(this.currentRuleSet, rulesList);
        this.setRules(this.defaultRules);
    }

    public void setLoggerRule(Rule loggerRule) {
        this.loggerRule = loggerRule;
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public void setFindRule(Rule findRule) {
        this.findRule = findRule;
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public Rule getFindRule() {
        return this.findRule;
    }

    public Rule getLoggerRule() {
        return this.loggerRule;
    }

    public void setRules(Map rules) {
        this.rules = rules;
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public Map getRules() {
        return this.rules;
    }

    public List getCurrentRules() {
        return (List)this.rules.get(this.currentRuleSet);
    }

    public void addRules(Map newRules) {
        for (Map.Entry o : newRules.entrySet()) {
            Map.Entry entry = o;
            if (this.rules.containsKey(entry.getKey())) {
                ((List)this.rules.get(entry.getKey())).addAll((List)entry.getValue());
                continue;
            }
            this.rules.put(entry.getKey(), entry.getValue());
        }
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public void addRule(String ruleSetName, ColorRule rule) {
        if (this.rules.containsKey(ruleSetName)) {
            ((List)this.rules.get(ruleSetName)).add(rule);
        } else {
            ArrayList<ColorRule> list = new ArrayList<ColorRule>();
            list.add(rule);
            this.rules.put(ruleSetName, list);
        }
        this.colorChangeSupport.firePropertyChange("colorrule", false, true);
    }

    public void removeRule(String ruleSetName, String expression) {
        if (this.rules.containsKey(ruleSetName)) {
            List list = (List)this.rules.get(ruleSetName);
            for (int i = 0; i < list.size(); ++i) {
                ColorRule rule = (ColorRule)list.get(i);
                if (!rule.getExpression().equals(expression)) continue;
                list.remove(rule);
                return;
            }
        }
    }

    public void setCurrentRuleSet(String ruleSetName) {
        this.currentRuleSet = ruleSetName;
    }

    @Override
    public Color getBackgroundColor(LoggingEvent event) {
        if (this.rules.containsKey(this.currentRuleSet)) {
            List list = (List)this.rules.get(this.currentRuleSet);
            for (Object aList : list) {
                ColorRule rule = (ColorRule)aList;
                if (rule.getBackgroundColor() == null || !rule.evaluate(event, null)) continue;
                return rule.getBackgroundColor();
            }
        }
        return null;
    }

    @Override
    public Color getForegroundColor(LoggingEvent event) {
        if (this.rules.containsKey(this.currentRuleSet)) {
            List list = (List)this.rules.get(this.currentRuleSet);
            for (Object aList : list) {
                ColorRule rule = (ColorRule)aList;
                if (rule.getForegroundColor() == null || !rule.evaluate(event, null)) continue;
                return rule.getForegroundColor();
            }
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.colorChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.colorChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.colorChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveColorSettings(String name) {
        ObjectOutputStream o = null;
        try {
            File f = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(name + COLORS_EXTENSION));
            o = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            o.writeObject(this.getRules());
            o.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (o != null) {
                    o.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void loadColorSettings(String name) {
        if (!this.doLoadColorSettings(name)) {
            this.doLoadColorSettings("Default");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doLoadColorSettings(String name) {
        File f = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(name) + COLORS_EXTENSION);
        if (f.exists()) {
            ObjectInputStream s = null;
            try {
                s = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
                Map map = (Map)s.readObject();
                this.setRules(map);
            }
            catch (EOFException ioe) {
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                f.delete();
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
        return f.exists();
    }

    public Vector getDefaultColors() {
        Vector<Color> vec = new Vector<Color>();
        vec.add(Color.white);
        vec.add(Color.black);
        vec.add(ChainsawConstants.COLOR_ODD_ROW_BACKGROUND);
        vec.add(ChainsawConstants.FIND_LOGGER_BACKGROUND);
        vec.add(new Color(255, 255, 225));
        vec.add(new Color(255, 225, 255));
        vec.add(new Color(225, 255, 255));
        vec.add(new Color(255, 225, 225));
        vec.add(new Color(225, 255, 225));
        vec.add(new Color(225, 225, 255));
        vec.add(new Color(225, 225, 183));
        vec.add(new Color(225, 183, 225));
        vec.add(new Color(183, 225, 225));
        vec.add(new Color(183, 225, 183));
        vec.add(new Color(183, 183, 225));
        vec.add(new Color(232, 201, 169));
        vec.add(new Color(255, 255, 153));
        vec.add(new Color(255, 153, 153));
        vec.add(new Color(189, 156, 89));
        vec.add(new Color(255, 102, 102));
        vec.add(new Color(255, 177, 61));
        vec.add(new Color(61, 255, 61));
        vec.add(new Color(153, 153, 255));
        vec.add(new Color(255, 153, 255));
        return vec;
    }
}

