/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.net.UDPReceiver;
import org.apache.log4j.plugins.Receiver;

class ReceiverConfigurationPanel
extends JPanel {
    private final Logger logger = LogManager.getLogger(ReceiverConfigurationPanel.class);
    private final PanelModel panelModel = new PanelModel();
    private JComboBox<String> networkReceiverPortComboBox;
    private JComboBox<String> networkReceiverClassNameComboBox;
    private DefaultComboBoxModel<String> networkReceiverClassNameComboBoxModel;
    private DefaultComboBoxModel<String> networkReceiverPortComboBoxModel;
    private JButton browseLog4jConfigButton;
    private JTextField log4jConfigURLTextField;
    private JButton browseLogFileButton;
    private JComboBox<String> logFileFormatTypeComboBox;
    private JComboBox<String> logFileFormatComboBox;
    private JComboBox<String> logFileFormatTimestampFormatComboBox;
    private JTextField logFileURLTextField;
    private DefaultComboBoxModel<String> logFileFormatComboBoxModel;
    private DefaultComboBoxModel<String> logFileFormatTimestampFormatComboBoxModel;
    private JButton browseForAnExistingConfigurationButton;
    private DefaultComboBoxModel<String> existingConfigurationComboBoxModel;
    private JComboBox<String> existingConfigurationComboBox;
    private JCheckBox dontwarnIfNoReceiver;
    private JButton saveButton;
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton log4jConfigReceiverRadioButton;
    private JRadioButton logFileReceiverRadioButton;
    private JRadioButton networkReceiverRadioButton;
    private JRadioButton useExistingConfigurationRadioButton;
    private ButtonGroup buttonGroup;
    private JPanel lowerPanel;
    private final JPanel networkReceiverPanel = this.buildNetworkReceiverPanel();
    private final JPanel logFileReceiverPanel = this.buildLogFileReceiverPanel();
    private final JPanel log4jConfigReceiverPanel = this.buildLog4jConfigReceiverPanel();
    private final JPanel useExistingConfigurationPanel = this.buildUseExistingConfigurationPanel();
    private final JPanel dontWarnAndOKPanel = this.buildDontWarnAndOKPanel();
    private final JPanel bottomDescriptionPanel = this.buildBottomDescriptionPanel();
    private ActionListener completionActionListener;
    private Container dialog;

    ReceiverConfigurationPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        this.setLayout(new GridBagLayout());
        this.buttonGroup = new ButtonGroup();
        this.lowerPanel = new JPanel(new BorderLayout());
        this.lowerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.lowerPanel.setPreferredSize(new Dimension(600, 200));
        this.lowerPanel.setMinimumSize(new Dimension(600, 200));
        int yPos = 0;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = yPos++;
        c.fill = 2;
        this.log4jConfigReceiverRadioButton = new JRadioButton(" Use fileappender entries from a log4j config file ");
        this.buttonGroup.add(this.log4jConfigReceiverRadioButton);
        this.add((Component)this.log4jConfigReceiverRadioButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = yPos++;
        c.fill = 2;
        this.logFileReceiverRadioButton = new JRadioButton(" Process a log file ");
        this.buttonGroup.add(this.logFileReceiverRadioButton);
        this.add((Component)this.logFileReceiverRadioButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = yPos++;
        c.fill = 2;
        this.networkReceiverRadioButton = new JRadioButton(" Receive events from the network ");
        this.buttonGroup.add(this.networkReceiverRadioButton);
        this.add((Component)this.networkReceiverRadioButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = yPos++;
        c.fill = 2;
        this.useExistingConfigurationRadioButton = new JRadioButton(" Use a Chainsaw config file ");
        this.buttonGroup.add(this.useExistingConfigurationRadioButton);
        this.add((Component)this.useExistingConfigurationRadioButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = yPos++;
        c.fill = 2;
        c.insets = new Insets(10, 10, 10, 0);
        this.add((Component)this.lowerPanel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = yPos++;
        c.weightx = 0.5;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.dontWarnAndOKPanel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = yPos++;
        c.fill = 2;
        c.insets = new Insets(10, 10, 10, 0);
        this.add((Component)this.bottomDescriptionPanel, c);
        ActionListener al = e -> this.updateEnabledState((Component)e.getSource());
        this.logFileReceiverRadioButton.addActionListener(al);
        this.log4jConfigReceiverRadioButton.addActionListener(al);
        this.networkReceiverRadioButton.addActionListener(al);
        this.useExistingConfigurationRadioButton.addActionListener(al);
        this.buttonGroup.setSelected(this.log4jConfigReceiverRadioButton.getModel(), true);
        this.updateEnabledState(this.log4jConfigReceiverRadioButton);
    }

    private JPanel buildDontWarnAndOKPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 21;
        this.dontwarnIfNoReceiver = new JCheckBox(" Always start Chainsaw with this configuration ");
        panel.add((Component)this.dontwarnIfNoReceiver, c);
        this.saveButton = new JButton(" Save configuration as... ");
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 10);
        panel.add((Component)this.saveButton, c);
        this.okButton = new JButton(" OK ");
        this.cancelButton = new JButton(" Cancel ");
        List<JButton> okCancelButtons = SwingHelper.orderOKCancelButtons(this.okButton, this.cancelButton);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 10);
        panel.add((Component)okCancelButtons.get(0), c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 0;
        panel.add((Component)okCancelButtons.get(1), c);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiverConfigurationPanel.this.panelModel.setCancelled(true);
                ReceiverConfigurationPanel.this.completionActionListener.actionPerformed(new ActionEvent(this, -1, "cancelled"));
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiverConfigurationPanel.this.panelModel.setCancelled(false);
                if (ReceiverConfigurationPanel.this.logFileFormatComboBox.getSelectedItem() != null && !ReceiverConfigurationPanel.this.logFileFormatComboBox.getSelectedItem().toString().trim().equals("")) {
                    ReceiverConfigurationPanel.this.panelModel.setLogFormat(ReceiverConfigurationPanel.this.logFileFormatComboBox.getSelectedItem().toString());
                }
                ReceiverConfigurationPanel.this.completionActionListener.actionPerformed(new ActionEvent(this, -1, "ok"));
            }
        });
        this.saveButton.addActionListener(e -> {
            try {
                URL url = this.browseFile("Choose a path and file name to save", false);
                if (url != null) {
                    File file = new File(url.toURI());
                    this.panelModel.setSaveConfigFile(file);
                }
            }
            catch (Exception ex) {
                this.logger.error("Error browsing for log file", ex);
            }
        });
        return panel;
    }

    private JPanel buildBottomDescriptionPanel() {
        JTextPane descriptionTextPane = new JTextPane();
        StyledDocument doc = descriptionTextPane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        descriptionTextPane.setText(" An example configuration file is available from the Welcome tab ");
        descriptionTextPane.setEditable(false);
        descriptionTextPane.setOpaque(false);
        descriptionTextPane.setFont(this.getFont());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)descriptionTextPane, c);
        return panel;
    }

    private JPanel buildNetworkReceiverPanel() {
        this.networkReceiverPortComboBoxModel = new DefaultComboBoxModel();
        this.networkReceiverPortComboBoxModel.addElement("4445");
        this.networkReceiverPortComboBoxModel.addElement("4560");
        this.networkReceiverPortComboBox = new JComboBox<String>(this.networkReceiverPortComboBoxModel);
        this.networkReceiverPortComboBox.setEditable(true);
        this.networkReceiverPortComboBox.setOpaque(false);
        this.networkReceiverClassNameComboBoxModel = new DefaultComboBoxModel();
        this.networkReceiverClassNameComboBoxModel.addElement(UDPReceiver.class.getName());
        this.networkReceiverClassNameComboBox = new JComboBox<String>(this.networkReceiverClassNameComboBoxModel);
        this.networkReceiverClassNameComboBox.setEditable(false);
        this.networkReceiverClassNameComboBox.setOpaque(false);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 5);
        panel.add(this.networkReceiverClassNameComboBox, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 0;
        panel.add(this.networkReceiverPortComboBox, c);
        return panel;
    }

    private JPanel buildLog4jConfigReceiverPanel() {
        this.log4jConfigURLTextField = new JTextField();
        this.browseLog4jConfigButton = new JButton(new AbstractAction(" Open File... "){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = ReceiverConfigurationPanel.this.browseConfig();
                    if (url != null) {
                        ReceiverConfigurationPanel.this.log4jConfigURLTextField.setText(url.toExternalForm());
                    }
                }
                catch (Exception ex) {
                    ReceiverConfigurationPanel.this.logger.error("Error browsing for log4j config file", ex);
                }
            }
        });
        this.browseLog4jConfigButton.setToolTipText("Shows a File Open dialog to allow you to find a log4j configuration file");
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.browseLog4jConfigButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 0, 5);
        panel.add((Component)new JLabel(" log4j configuration file URL "), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.5;
        c.fill = 2;
        panel.add((Component)this.log4jConfigURLTextField, c);
        return panel;
    }

    private JPanel buildLogFileReceiverPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.browseLogFileButton = new JButton(new AbstractAction(" Open File... "){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = ReceiverConfigurationPanel.this.browseFile("Select a log file", true);
                    if (url != null) {
                        String item = url.toURI().toString();
                        ReceiverConfigurationPanel.this.logFileURLTextField.setText(item);
                    }
                }
                catch (Exception ex) {
                    ReceiverConfigurationPanel.this.logger.error("Error browsing for log file", ex);
                }
            }
        });
        this.browseLogFileButton.setToolTipText("Shows a File Open dialog to allow you to find a log file");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.browseLogFileButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 22;
        c.insets = new Insets(0, 0, 5, 5);
        panel.add((Component)new JLabel(" Log file URL "), c);
        this.logFileURLTextField = new JTextField();
        this.logFileURLTextField.setEditable(true);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.logFileURLTextField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 22;
        c.insets = new Insets(0, 0, 5, 5);
        panel.add((Component)new JLabel(" Log file format type "), c);
        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
        comboBoxModel.addElement("LogFilePatternReceiver LogFormat");
        comboBoxModel.addElement("PatternLayout format");
        this.logFileFormatTypeComboBox = new JComboBox(comboBoxModel);
        this.logFileFormatTypeComboBox.setOpaque(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 5, 0);
        panel.add(this.logFileFormatTypeComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 22;
        c.insets = new Insets(0, 5, 5, 5);
        panel.add((Component)new JLabel(" Log file format "), c);
        this.logFileFormatComboBoxModel = new DefaultComboBoxModel();
        this.seedLogFileFormatComboBoxModel();
        this.logFileFormatComboBox = new JComboBox<String>(this.logFileFormatComboBoxModel);
        this.logFileFormatComboBox.setEditable(true);
        this.logFileFormatComboBox.setOpaque(false);
        this.logFileFormatComboBox.setSelectedIndex(0);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 0.5;
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        panel.add(this.logFileFormatComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.insets = new Insets(0, 5, 5, 5);
        panel.add((Component)new JLabel(" Log file timestamp format "), c);
        this.logFileFormatTimestampFormatComboBoxModel = new DefaultComboBoxModel();
        this.seedLogFileFormatTimestampComboBoxModel();
        this.logFileFormatTimestampFormatComboBox = new JComboBox<String>(this.logFileFormatTimestampFormatComboBoxModel);
        this.logFileFormatTimestampFormatComboBox.setEditable(true);
        this.logFileFormatTimestampFormatComboBox.setOpaque(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 0.5;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add(this.logFileFormatTimestampFormatComboBox, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 5;
        c.insets = new Insets(15, 5, 0, 5);
        panel.add((Component)new JLabel("<html> See PatternLayout or LogFilePatternReceiver JavaDoc for details </html>"), c);
        return panel;
    }

    private void seedLogFileFormatComboBoxModel() {
        this.logFileFormatComboBoxModel.addElement("MESSAGE");
        this.logFileFormatComboBoxModel.addElement("%p %t %c - %m%n");
        this.logFileFormatComboBoxModel.addElement("LEVEL THREAD LOGGER - MESSAGE");
        this.logFileFormatComboBoxModel.addElement("%d{ABSOLUTE} %-5p [%c{1}] %m%n");
        this.logFileFormatComboBoxModel.addElement("TIMESTAMP LEVEL [LOGGER] MESSAGE");
    }

    private void seedLogFileFormatTimestampComboBoxModel() {
        this.logFileFormatTimestampFormatComboBoxModel.addElement("yyyy-MM-dd HH:mm:ss,SSS");
        this.logFileFormatTimestampFormatComboBoxModel.addElement("yyyyMMdd HH:mm:ss.SSS");
        this.logFileFormatTimestampFormatComboBoxModel.addElement("yyyy/MM/dd HH:mm:ss");
        this.logFileFormatTimestampFormatComboBoxModel.addElement("dd MMM yyyy HH:mm:ss,SSS");
        this.logFileFormatTimestampFormatComboBoxModel.addElement("HH:mm:ss,SSS");
        this.logFileFormatTimestampFormatComboBoxModel.addElement("yyyy-MM-ddTHH:mm");
        this.logFileFormatTimestampFormatComboBoxModel.addElement("yyyy-MM-ddTHH:mm:ss.SSS");
    }

    private JPanel buildUseExistingConfigurationPanel() {
        this.existingConfigurationComboBoxModel = new DefaultComboBoxModel();
        this.existingConfigurationComboBox = new JComboBox<String>(this.existingConfigurationComboBoxModel);
        this.existingConfigurationComboBox.setOpaque(false);
        this.existingConfigurationComboBox.setToolTipText("Previously loaded configurations can be chosen here");
        this.existingConfigurationComboBox.setEditable(true);
        this.existingConfigurationComboBox.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                this.selectAll();
            }

            private void selectAll() {
                ReceiverConfigurationPanel.this.existingConfigurationComboBox.getEditor().selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.browseForAnExistingConfigurationButton = new JButton(new AbstractAction(" Open File... "){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = ReceiverConfigurationPanel.this.browseConfig();
                    if (url != null) {
                        ReceiverConfigurationPanel.this.existingConfigurationComboBoxModel.addElement(url.toExternalForm());
                        ReceiverConfigurationPanel.this.existingConfigurationComboBox.getModel().setSelectedItem(url);
                    }
                }
                catch (Exception ex) {
                    ReceiverConfigurationPanel.this.logger.error("Error browsing for Configuration file", ex);
                }
            }
        });
        this.browseForAnExistingConfigurationButton.setToolTipText("Shows a File Open dialog to allow you to find a configuration file");
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.browseForAnExistingConfigurationButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 0, 5);
        panel.add((Component)new JLabel(" Configuration file URL "), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.5;
        c.fill = 2;
        panel.add(this.existingConfigurationComboBox, c);
        return panel;
    }

    PanelModel getModel() {
        return this.panelModel;
    }

    void setCompletionActionListener(ActionListener actionListener) {
        this.completionActionListener = actionListener;
    }

    private void updateEnabledState(Component component) {
        this.lowerPanel.removeAll();
        if (component == this.useExistingConfigurationRadioButton) {
            this.lowerPanel.add((Component)this.useExistingConfigurationPanel, "North");
        }
        if (component == this.networkReceiverRadioButton) {
            this.lowerPanel.add((Component)this.networkReceiverPanel, "North");
        }
        if (component == this.logFileReceiverRadioButton) {
            this.lowerPanel.add((Component)this.logFileReceiverPanel, "North");
        }
        if (component == this.log4jConfigReceiverRadioButton) {
            this.lowerPanel.add((Component)this.log4jConfigReceiverPanel, "North");
        }
        this.lowerPanel.revalidate();
        this.lowerPanel.repaint();
    }

    private URL browseConfig() throws MalformedURLException {
        this.dialog.setVisible(false);
        File selectedFile = SwingHelper.promptForFile(this.dialog, null, "Choose a Chainsaw configuration file", true);
        URL result = null;
        if (selectedFile == null) {
            result = null;
        }
        if (!(selectedFile == null || selectedFile.exists() && selectedFile.canRead())) {
            result = null;
        }
        if (selectedFile != null) {
            result = selectedFile.toURI().toURL();
        }
        EventQueue.invokeLater(() -> this.dialog.setVisible(true));
        return result;
    }

    private URL browseFile(String title, boolean loadDialog) throws MalformedURLException {
        this.dialog.setVisible(false);
        File selectedFile = SwingHelper.promptForFile(this.dialog, null, title, loadDialog);
        URL result = null;
        if (selectedFile == null) {
            result = null;
        }
        if (!(selectedFile == null || selectedFile.exists() && selectedFile.canRead())) {
            result = null;
        }
        if (selectedFile != null) {
            result = selectedFile.toURI().toURL();
        }
        EventQueue.invokeLater(() -> this.dialog.setVisible(true));
        return result;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ReceiverConfigurationPanel());
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public final boolean isDontWarnMeAgain() {
        return this.dontwarnIfNoReceiver.isSelected();
    }

    public void setDialog(Container dialog) {
        this.dialog = dialog;
    }

    class PanelModel {
        private File file = new File(SettingsManager.getInstance().getSettingsDirectory(), "receiver-config.xml");
        private boolean cancelled = true;
        private String lastLogFormat;
        private File saveConfigFile;

        boolean isNetworkReceiverMode() {
            return !this.cancelled && ReceiverConfigurationPanel.this.networkReceiverRadioButton.isSelected();
        }

        int getNetworkReceiverPort() {
            return Integer.parseInt(ReceiverConfigurationPanel.this.networkReceiverPortComboBoxModel.getSelectedItem().toString());
        }

        Class<? extends Receiver> getNetworkReceiverClass() throws ClassNotFoundException {
            return Class.forName(ReceiverConfigurationPanel.this.networkReceiverClassNameComboBoxModel.getSelectedItem().toString()).asSubclass(Receiver.class);
        }

        boolean isLoadConfig() {
            return !this.cancelled && ReceiverConfigurationPanel.this.useExistingConfigurationRadioButton.isSelected();
        }

        boolean isLogFileReceiverConfig() {
            return !this.cancelled && ReceiverConfigurationPanel.this.logFileReceiverRadioButton.isSelected();
        }

        boolean isLog4jConfig() {
            return !this.cancelled && ReceiverConfigurationPanel.this.log4jConfigReceiverRadioButton.isSelected();
        }

        URL getConfigToLoad() {
            try {
                return new URL(ReceiverConfigurationPanel.this.existingConfigurationComboBoxModel.getSelectedItem().toString());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        URL getDefaultConfigFileURL() {
            try {
                return this.file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                ReceiverConfigurationPanel.this.logger.error("Error loading saved configurations by Chainsaw", e);
                return null;
            }
        }

        File getSaveConfigFile() {
            return this.saveConfigFile;
        }

        void setSaveConfigFile(File file) {
            this.saveConfigFile = file;
        }

        URL getLogFileURL() {
            try {
                String item = ReceiverConfigurationPanel.this.logFileURLTextField.getText();
                if (item != null) {
                    return new URL(item.toString());
                }
            }
            catch (MalformedURLException e) {
                ReceiverConfigurationPanel.this.logger.error("Error retrieving log file URL", e);
            }
            return null;
        }

        String getLogFormat() {
            if (this.cancelled) {
                return this.lastLogFormat;
            }
            Object item = ReceiverConfigurationPanel.this.logFileFormatComboBox.getSelectedItem();
            if (item != null) {
                return item.toString();
            }
            return null;
        }

        boolean isPatternLayoutLogFormat() {
            Object item = ReceiverConfigurationPanel.this.logFileFormatTypeComboBox.getSelectedItem();
            return item != null && item.toString().toLowerCase(Locale.ENGLISH).contains("patternlayout");
        }

        String getLogFormatTimestampFormat() {
            Object item = ReceiverConfigurationPanel.this.logFileFormatTimestampFormatComboBox.getSelectedItem();
            if (item != null) {
                return item.toString();
            }
            return null;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public void setLogFormat(String lastLogFormat) {
            this.lastLogFormat = lastLogFormat;
            ReceiverConfigurationPanel.this.logFileFormatComboBoxModel.removeElement(lastLogFormat);
            ReceiverConfigurationPanel.this.logFileFormatComboBoxModel.insertElementAt(lastLogFormat, 0);
            ReceiverConfigurationPanel.this.logFileFormatComboBox.setSelectedIndex(0);
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public File getLog4jConfigFile() {
            try {
                URL newConfigurationURL = new URL(ReceiverConfigurationPanel.this.log4jConfigURLTextField.getText());
                return new File(newConfigurationURL.toURI());
            }
            catch (MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

