/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;

public class CompareOperationContext
extends AbstractOperationContext {
    private String oid;
    private AttributeType attributeType;
    private Value<?> value;

    public CompareOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.COMPARE));
        }
    }

    public CompareOperationContext(CoreSession session, Dn dn) {
        super(session, dn);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.COMPARE));
        }
    }

    public CompareOperationContext(CoreSession session, String oid) {
        super(session);
        this.oid = oid;
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.COMPARE));
        }
    }

    public CompareOperationContext(CoreSession session, Dn dn, String oid) {
        super(session, dn);
        this.oid = oid;
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.COMPARE));
        }
    }

    public CompareOperationContext(CoreSession session, Dn dn, String oid, Value<?> value) {
        super(session, dn);
        this.oid = oid;
        this.value = value;
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.COMPARE));
        }
    }

    public CompareOperationContext(CoreSession session, CompareRequest compareRequest) {
        super(session, compareRequest.getName());
        this.oid = compareRequest.getAttributeId();
        this.value = compareRequest.getAssertionValue();
        this.requestControls = compareRequest.getControls();
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.COMPARE));
        }
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public Value<?> getValue() {
        return this.value;
    }

    public void setValue(Value<?> value) {
        this.value = value;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.COMPARE_REQUEST.name();
    }

    public String toString() {
        return "CompareContext for Dn '" + this.getDn().getName() + "'" + (this.oid != null ? ", oid : <" + this.oid + ">" : "") + (this.value != null ? ", value :'" + (this.value.isHumanReadable() ? this.value.getString() : (!this.value.isHumanReadable() ? Strings.dumpBytes((byte[])((BinaryValue)this.value).getReference()) : "unknown value type")) + "'" : "");
    }
}

