/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.HttpWebAppBean;
import org.apache.directory.server.config.beans.ServerBean;

public class HttpServerBean
extends ServerBean {
    @ConfigurationElement(attributeType="ads-httpConfFile", isOptional=true)
    private String httpConfFile;
    @ConfigurationElement(objectClass="ads-httpWebApp", container="httpWebApps")
    private List<HttpWebAppBean> httpWebApps = new ArrayList<HttpWebAppBean>();

    public HttpServerBean() {
        this.setEnabled(true);
    }

    public String getHttpConfFile() {
        return this.httpConfFile;
    }

    public void setHttpConfFile(String httpConfFile) {
        this.httpConfFile = httpConfFile;
    }

    public List<HttpWebAppBean> getHttpWebApps() {
        return this.httpWebApps;
    }

    public void setHttpWebApps(List<HttpWebAppBean> httpWebApps) {
        this.httpWebApps = httpWebApps;
    }

    public void addHttpWebApps(HttpWebAppBean ... httpWebApps) {
        for (HttpWebAppBean httpWebApp : httpWebApps) {
            this.httpWebApps.add(httpWebApp);
        }
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("HttpServer :\n");
        sb.append(super.toString(tabs + "  "));
        sb.append(this.toString(tabs, "  http configuration file", this.httpConfFile));
        if (this.httpWebApps != null && this.httpWebApps.size() > 0) {
            sb.append(tabs).append("  web applications :\n");
            for (HttpWebAppBean httpWebApp : this.httpWebApps) {
                sb.append(httpWebApp.toString(tabs + "    "));
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

