/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.EmptyTupleCursor;
import org.apache.directory.mavibot.btree.EmptyValueCursor;
import org.apache.directory.mavibot.btree.ExistsResult;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.KeyCursor;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.TransactionManager;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.exception.BTreeCreationException;
import org.apache.directory.mavibot.btree.exception.DuplicateValueNotAllowedException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

abstract class AbstractBTree<K, V>
implements BTree<K, V> {
    protected long readTimeOut = 10000L;
    protected BTreeHeader<K, V> currentBtreeHeader;
    protected ElementSerializer<K> keySerializer;
    protected ElementSerializer<V> valueSerializer;
    protected ConcurrentLinkedQueue<ReadTransaction<K, V>> readTransactions;
    protected int writeBufferSize;
    protected boolean allowDuplicates;
    protected int pageSize;
    protected String name;
    protected String keySerializerFQCN;
    protected String valueSerializerFQCN;
    protected Thread readTransactionsThread;
    protected BTreeTypeEnum btreeType;
    protected AtomicBoolean transactionStarted = new AtomicBoolean(false);
    protected Map<Long, BTreeHeader<K, V>> btreeRevisions = new ConcurrentHashMap<Long, BTreeHeader<K, V>>();
    protected AtomicLong currentRevision = new AtomicLong(0L);
    protected TransactionManager transactionManager;

    AbstractBTree() {
    }

    protected abstract ReadTransaction<K, V> beginReadTransaction();

    protected abstract ReadTransaction<K, V> beginReadTransaction(long var1);

    @Override
    public TupleCursor<K, V> browse() throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        if (transaction == null) {
            return new EmptyTupleCursor();
        }
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        TupleCursor<K, V> cursor = this.getRootPage().browse(transaction, stack, 0);
        cursor.beforeFirst();
        return cursor;
    }

    @Override
    public TupleCursor<K, V> browse(long revision) throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction(revision);
        if (transaction == null) {
            return new EmptyTupleCursor();
        }
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        TupleCursor cursor = this.getRootPage(transaction.getRevision()).browse(transaction, stack, 0);
        return cursor;
    }

    @Override
    public TupleCursor<K, V> browseFrom(K key) throws IOException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        try {
            TupleCursor cursor = this.getRootPage(transaction.getRevision()).browse(key, transaction, stack, 0);
            return cursor;
        }
        catch (KeyNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public TupleCursor<K, V> browseFrom(long revision, K key) throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction(revision);
        if (transaction == null) {
            return new EmptyTupleCursor();
        }
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        TupleCursor cursor = this.getRootPage(transaction.getRevision()).browse(key, transaction, stack, 0);
        return cursor;
    }

    @Override
    public boolean contains(K key, V value) throws IOException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        if (transaction == null) {
            return false;
        }
        try {
            boolean bl = this.getRootPage(transaction.getRevision()).contains(key, value);
            return bl;
        }
        catch (KeyNotFoundException knfe) {
            throw new IOException(knfe.getMessage());
        }
        finally {
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(long revision, K key, V value) throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction(revision);
        if (transaction == null) {
            return false;
        }
        try {
            boolean bl = this.getRootPage(transaction.getRevision()).contains(key, value);
            return bl;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public Tuple<K, V> delete(K key) throws IOException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        this.transactionManager.beginTransaction();
        try {
            Tuple<K, V> deleted = this.delete(key, this.currentRevision.get() + 1L);
            this.transactionManager.commit();
            return deleted;
        }
        catch (IOException ioe) {
            this.transactionManager.rollback();
            return null;
        }
    }

    @Override
    public Tuple<K, V> delete(K key, V value) throws IOException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        this.transactionManager.beginTransaction();
        try {
            Tuple<K, V> deleted = this.delete(key, value, this.currentRevision.get() + 1L);
            this.transactionManager.commit();
            return deleted;
        }
        catch (IOException ioe) {
            this.transactionManager.rollback();
            throw ioe;
        }
    }

    @Override
    Tuple<K, V> delete(K key, long revision) throws IOException {
        return this.delete(key, null, revision);
    }

    abstract Tuple<K, V> delete(K var1, V var2, long var3) throws IOException;

    @Override
    public V insert(K key, V value) throws IOException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        V existingValue = null;
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (this.btreeType != BTreeTypeEnum.PERSISTED_SUB) {
            this.transactionManager.beginTransaction();
        }
        try {
            InsertResult<K, V> result = this.insert(key, value, -1L);
            if (result instanceof ExistsResult) {
                existingValue = value;
            } else if (result instanceof ModifyResult) {
                existingValue = ((ModifyResult)result).getModifiedValue();
            }
            if (this.btreeType != BTreeTypeEnum.PERSISTED_SUB) {
                this.transactionManager.commit();
            }
            return existingValue;
        }
        catch (IOException ioe) {
            if (this.btreeType != BTreeTypeEnum.PERSISTED_SUB) {
                this.transactionManager.rollback();
            }
            return null;
        }
        catch (DuplicateValueNotAllowedException e) {
            if (this.btreeType != BTreeTypeEnum.PERSISTED_SUB) {
                this.transactionManager.rollback();
            }
            throw e;
        }
    }

    abstract InsertResult<K, V> insert(K var1, V var2, long var3) throws IOException;

    @Override
    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        if (transaction == null) {
            return null;
        }
        try {
            Object v = this.getRootPage(transaction.getRevision()).get(key);
            return v;
        }
        finally {
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long revision, K key) throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction(revision);
        if (transaction == null) {
            return null;
        }
        try {
            Object v = this.getRootPage(transaction.getRevision()).get(key);
            return v;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public abstract Page<K, V> getRootPage();

    abstract void setRootPage(Page<K, V> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueCursor<V> getValues(K key) throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        if (transaction == null) {
            return new EmptyValueCursor(0L);
        }
        try {
            ValueCursor valueCursor = this.getRootPage(transaction.getRevision()).getValues(key);
            return valueCursor;
        }
        finally {
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(K key) throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        if (key == null) {
            return false;
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        if (transaction == null) {
            return false;
        }
        try {
            boolean bl = this.getRootPage(transaction.getRevision()).hasKey(key);
            return bl;
        }
        finally {
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(long revision, K key) throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        if (key == null) {
            return false;
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction(revision);
        if (transaction == null) {
            return false;
        }
        try {
            boolean bl = this.getRootPage(transaction.getRevision()).hasKey(key);
            return bl;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public ElementSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public void setKeySerializer(ElementSerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
        this.keySerializerFQCN = keySerializer.getClass().getName();
    }

    @Override
    public String getKeySerializerFQCN() {
        return this.keySerializerFQCN;
    }

    @Override
    public ElementSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public void setValueSerializer(ElementSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        this.valueSerializerFQCN = valueSerializer.getClass().getName();
    }

    @Override
    public String getValueSerializerFQCN() {
        return this.valueSerializerFQCN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRevision() {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        if (transaction == null) {
            return -1L;
        }
        try {
            long l = transaction.getRevision();
            return l;
        }
        finally {
            transaction.close();
        }
    }

    void setRevision(long revision) {
        this.transactionManager.getBTreeHeader(this.getName()).setRevision(revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeRevision(BTreeHeader<K, V> btreeHeader, boolean keepRevisions) {
        long revision = btreeHeader.getRevision();
        if (keepRevisions) {
            Map<Long, BTreeHeader<K, V>> map = this.btreeRevisions;
            synchronized (map) {
                this.btreeRevisions.put(revision, btreeHeader);
            }
        }
        this.currentRevision.set(revision);
        this.currentBtreeHeader = btreeHeader;
        if (btreeHeader.getBtree().getType() != BTreeTypeEnum.PERSISTED_SUB) {
            this.transactionManager.updateNewBTreeHeaders(btreeHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeRevision(BTreeHeader<K, V> btreeHeader) {
        long revision = btreeHeader.getRevision();
        Map<Long, BTreeHeader<K, V>> map = this.btreeRevisions;
        synchronized (map) {
            this.btreeRevisions.put(revision, btreeHeader);
        }
        this.currentRevision.set(revision);
        this.currentBtreeHeader = btreeHeader;
        if (btreeHeader.getBtree().getType() != BTreeTypeEnum.PERSISTED_SUB) {
            this.transactionManager.updateNewBTreeHeaders(btreeHeader);
        }
    }

    @Override
    public long getReadTimeOut() {
        return this.readTimeOut;
    }

    @Override
    public void setReadTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNbElems() {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a transactionLManager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        if (transaction == null) {
            return -1L;
        }
        try {
            long l = transaction.getBtreeHeader().getNbElems();
            return l;
        }
        finally {
            transaction.close();
        }
    }

    void setNbElems(long nbElems) {
        this.transactionManager.getBTreeHeader(this.getName()).setNbElems(nbElems);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 2 ? 16 : this.getPowerOf2(pageSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Comparator<K> getKeyComparator() {
        return this.keySerializer.getComparator();
    }

    @Override
    public Comparator<V> getValueComparator() {
        return this.valueSerializer.getComparator();
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public BTreeTypeEnum getType() {
        return this.btreeType;
    }

    public void setType(BTreeTypeEnum type) {
        this.btreeType = type;
    }

    private int getPowerOf2(int size) {
        int newSize = --size;
        newSize |= newSize >> 1;
        newSize |= newSize >> 2;
        newSize |= newSize >> 4;
        newSize |= newSize >> 8;
        newSize |= newSize >> 16;
        return ++newSize;
    }

    protected BTreeHeader<K, V> getBtreeHeader() {
        return this.currentBtreeHeader;
    }

    protected BTreeHeader<K, V> getBtreeHeader(long revision) {
        return this.btreeRevisions.get(revision);
    }

    @Override
    public KeyCursor<K> browseKeys() throws IOException, KeyNotFoundException {
        if (this.transactionManager == null) {
            throw new BTreeCreationException("We don't have a Transaction Manager");
        }
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        if (transaction == null) {
            return new KeyCursor();
        }
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        KeyCursor<K> cursor = this.getRootPage().browseKeys(transaction, stack, 0);
        cursor.beforeFirst();
        return cursor;
    }

    void createTransactionManager() {
        Runnable readTransactionTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ReadTransaction transaction = null;
                    while (!Thread.currentThread().isInterrupted()) {
                        long timeoutDate = System.currentTimeMillis() - AbstractBTree.this.readTimeOut;
                        long t0 = System.currentTimeMillis();
                        int nbTxns = 0;
                        while ((transaction = AbstractBTree.this.readTransactions.peek()) != null) {
                            ++nbTxns;
                            if (transaction.isClosed()) {
                                AbstractBTree.this.readTransactions.poll();
                                continue;
                            }
                            if (transaction.getCreationDate() >= timeoutDate) break;
                            transaction.close();
                            AbstractBTree.this.readTransactions.poll();
                            Map map = AbstractBTree.this.btreeRevisions;
                            synchronized (map) {
                                AbstractBTree.this.btreeRevisions.remove(transaction.getRevision());
                            }
                        }
                        long t1 = System.currentTimeMillis();
                        Thread.sleep(AbstractBTree.this.readTimeOut);
                    }
                }
                catch (InterruptedException transaction) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.readTransactionsThread = new Thread(readTransactionTask);
        this.readTransactionsThread.setDaemon(true);
        this.readTransactionsThread.start();
    }
}

