/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.knoxtoken.TokenServiceMessages;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.util.JsonUtils;

@Path(value="knoxtoken/api/v1/token")
public class TokenResource {
    private static final String EXPIRES_IN = "expires_in";
    private static final String TOKEN_TYPE = "token_type";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TARGET_URL = "target_url";
    private static final String BEARER = "Bearer";
    private static final String TOKEN_TTL_PARAM = "knox.token.ttl";
    private static final String TOKEN_AUDIENCES_PARAM = "knox.token.audiences";
    private static final String TOKEN_TARGET_URL = "knox.token.target.url";
    private static final String TOKEN_CLIENT_DATA = "knox.token.client.data";
    private static final String TOKEN_CLIENT_CERT_REQUIRED = "knox.token.client.cert.required";
    private static final String TOKEN_ALLOWED_PRINCIPALS = "knox.token.allowed.principals";
    private static final String TOKEN_SIG_ALG = "knox.token.sigalg";
    private static final long TOKEN_TTL_DEFAULT = 30000L;
    static final String RESOURCE_PATH = "knoxtoken/api/v1/token";
    private static TokenServiceMessages log = (TokenServiceMessages)MessagesFactory.get(TokenServiceMessages.class);
    private long tokenTTL = 30000L;
    private List<String> targetAudiences = new ArrayList<String>();
    private String tokenTargetUrl = null;
    private Map<String, Object> tokenClientDataMap = null;
    private ArrayList<String> allowedDNs = new ArrayList();
    private boolean clientCertRequired = false;
    private String signatureAlgorithm = "RS256";
    @Context
    HttpServletRequest request;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() {
        String sigAlg;
        String ttl;
        String audiences = this.context.getInitParameter(TOKEN_AUDIENCES_PARAM);
        if (audiences != null) {
            String[] auds = audiences.split(",");
            for (int i = 0; i < auds.length; ++i) {
                this.targetAudiences.add(auds[i].trim());
            }
        }
        String clientCert = this.context.getInitParameter(TOKEN_CLIENT_CERT_REQUIRED);
        this.clientCertRequired = "true".equals(clientCert);
        String principals = this.context.getInitParameter(TOKEN_ALLOWED_PRINCIPALS);
        if (principals != null) {
            String[] dns = principals.split(";");
            for (int i = 0; i < dns.length; ++i) {
                this.allowedDNs.add(dns[i].replaceAll("\\s+", ""));
            }
        }
        if ((ttl = this.context.getInitParameter(TOKEN_TTL_PARAM)) != null) {
            try {
                this.tokenTTL = Long.parseLong(ttl);
                if (this.tokenTTL < -1L || this.tokenTTL + System.currentTimeMillis() < 0L) {
                    log.invalidTokenTTLEncountered(ttl);
                    this.tokenTTL = 30000L;
                }
            }
            catch (NumberFormatException nfe) {
                log.invalidTokenTTLEncountered(ttl);
            }
        }
        this.tokenTargetUrl = this.context.getInitParameter(TOKEN_TARGET_URL);
        String clientData = this.context.getInitParameter(TOKEN_CLIENT_DATA);
        if (clientData != null) {
            this.tokenClientDataMap = new HashMap<String, Object>();
            String[] tokenClientData = clientData.split(",");
            this.addClientDataToMap(tokenClientData, this.tokenClientDataMap);
        }
        if ((sigAlg = this.context.getInitParameter(TOKEN_SIG_ALG)) != null) {
            this.signatureAlgorithm = sigAlg;
        }
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return this.getAuthenticationToken();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return this.getAuthenticationToken();
    }

    private X509Certificate extractCertificate(HttpServletRequest req) {
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    private Response getAuthenticationToken() {
        if (this.clientCertRequired) {
            X509Certificate cert = this.extractCertificate(this.request);
            if (cert != null) {
                if (!this.allowedDNs.contains(cert.getSubjectDN().getName().replaceAll("\\s+", ""))) {
                    return Response.status((int)403).entity((Object)"{ \"Unable to get token - untrusted client cert.\" }").build();
                }
            } else {
                return Response.status((int)403).entity((Object)"{ \"Unable to get token - client cert required.\" }").build();
            }
        }
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        JWTokenAuthority ts = (JWTokenAuthority)services.getService("TokenService");
        Principal p = this.request.getUserPrincipal();
        long expires = this.getExpiry();
        try {
            JWT token = null;
            token = this.targetAudiences.isEmpty() ? ts.issueToken(p, this.signatureAlgorithm, expires) : ts.issueToken(p, this.targetAudiences, this.signatureAlgorithm, expires);
            if (token != null) {
                String accessToken = token.toString();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ACCESS_TOKEN, accessToken);
                map.put(TOKEN_TYPE, BEARER);
                map.put(EXPIRES_IN, expires);
                if (this.tokenTargetUrl != null) {
                    map.put(TARGET_URL, this.tokenTargetUrl);
                }
                if (this.tokenClientDataMap != null) {
                    map.putAll(this.tokenClientDataMap);
                }
                String jsonResponse = JsonUtils.renderAsJsonString(map);
                return Response.ok().entity((Object)jsonResponse).build();
            }
            return Response.serverError().build();
        }
        catch (TokenServiceException e) {
            log.unableToIssueToken((Exception)((Object)e));
            return Response.ok().entity((Object)"{ \"Unable to acquire token.\" }").build();
        }
    }

    void addClientDataToMap(String[] tokenClientData, Map<String, Object> map) {
        String[] kv = null;
        for (int i = 0; i < tokenClientData.length; ++i) {
            kv = tokenClientData[i].split("=");
            if (kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
    }

    private long getExpiry() {
        long expiry = 0L;
        expiry = this.tokenTTL == -1L ? -1L : System.currentTimeMillis() + this.tokenTTL;
        return expiry;
    }
}

