/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt;

import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.provider.federation.jwt")
public interface JWTMessages {
    @Message(level=MessageLevel.WARN, text="Failed to validate the audience attribute.")
    public void failedToValidateAudience();

    @Message(level=MessageLevel.WARN, text="Failed to verify the token signature.")
    public void failedToVerifyTokenSignature();

    @Message(level=MessageLevel.INFO, text="Access token has expired; a new one must be acquired.")
    public void tokenHasExpired();

    @Message(level=MessageLevel.INFO, text="The NotBefore check failed.")
    public void notBeforeCheckFailed();

    @Message(level=MessageLevel.WARN, text="Expected Bearer token is missing.")
    public void missingBearerToken();

    @Message(level=MessageLevel.INFO, text="Unable to verify token: {0}")
    public void unableToVerifyToken(@StackTrace(level=MessageLevel.ERROR) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Unable to verify token: {0}")
    public void unableToIssueToken(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.DEBUG, text="Sending redirect to: {0}")
    public void sendRedirectToLoginURL(String var1);

    @Message(level=MessageLevel.WARN, text="Configuration for authentication provider URL is missing - will derive default URL.")
    public void missingAuthenticationProviderUrlConfiguration();

    @Message(level=MessageLevel.DEBUG, text="{0} Cookie has been found and is being processed.")
    public void cookieHasBeenFound(String var1);

    @Message(level=MessageLevel.DEBUG, text="Audience claim has been validated.")
    public void jwtAudienceValidated();
}

