/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.hadoop.groups.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.identityasserter.common.filter.CommonIdentityAssertionFilter;
import org.apache.knox.gateway.identityasserter.hadoop.groups.filter.HadoopGroupProviderMessages;

public class HadoopGroupProviderFilter
extends CommonIdentityAssertionFilter {
    public static final HadoopGroupProviderMessages LOG = (HadoopGroupProviderMessages)MessagesFactory.get(HadoopGroupProviderMessages.class);
    private Configuration hadoopConfig;
    private Groups hadoopGroups;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            this.hadoopConfig = new Configuration(false);
            if (filterConfig.getInitParameterNames() != null) {
                Enumeration keys = filterConfig.getInitParameterNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    this.hadoopConfig.set(key, filterConfig.getInitParameter(key));
                }
            }
            this.hadoopGroups = new Groups(this.hadoopConfig);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String[] mapGroupPrincipals(String mappedPrincipalName, Subject subject) {
        String[] groups = null;
        try {
            List groupList = this.hadoopGroups.getGroups(mappedPrincipalName);
            LOG.groupsFound(mappedPrincipalName, groupList.toString());
            groups = groupList.toArray(new String[0]);
        }
        catch (IOException e) {
            if (e.toString().contains("No groups found for user")) {
                LOG.noGroupsFound(mappedPrincipalName);
            } else {
                LOG.errorGettingUserGroups(mappedPrincipalName, e);
            }
            groups = new String[]{};
        }
        return groups;
    }

    public String mapUserPrincipal(String principalName) {
        return principalName;
    }
}

