/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class X509CertificateUtil {
    private static GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);

    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm) {
        PrivateKey privkey = pair.getPrivate();
        Object x509CertImplObject = null;
        try {
            Date from = new Date();
            Date to = new Date(from.getTime() + (long)days * 86400000L);
            Class<?> certInfoClass = Class.forName(X509CertificateUtil.getX509CertInfoModuleName());
            Constructor<?> certInfoConstr = certInfoClass.getConstructor(new Class[0]);
            Object certInfoObject = certInfoConstr.newInstance(new Object[0]);
            Class<?> certValidityClass = Class.forName(X509CertificateUtil.getX509CertifValidityModuleName());
            Constructor<?> certValidityConstr = certValidityClass.getConstructor(Date.class, Date.class);
            Object certValidityObject = certValidityConstr.newInstance(from, to);
            BigInteger sn = new BigInteger(64, new SecureRandom());
            Class<?> x500NameClass = Class.forName(X509CertificateUtil.getX509X500NameModuleName());
            Constructor<?> x500NameConstr = x500NameClass.getConstructor(String.class);
            Object x500NameObject = x500NameConstr.newInstance(dn);
            Method methodSET = certInfoObject.getClass().getMethod("set", String.class, Object.class);
            methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "VALIDITY"), certValidityObject);
            Class<?> certificateSerialNumberClass = Class.forName(X509CertificateUtil.getCertificateSerialNumberModuleName());
            Constructor<?> certificateSerialNumberConstr = certificateSerialNumberClass.getConstructor(BigInteger.class);
            Object certificateSerialNumberObject = certificateSerialNumberConstr.newInstance(sn);
            methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "SERIAL_NUMBER"), certificateSerialNumberObject);
            try {
                Class<?> certificateSubjectNameClass = Class.forName(X509CertificateUtil.getCertificateSubjectNameModuleName());
                Constructor<?> certificateSubjectNameConstr = certificateSubjectNameClass.getConstructor(x500NameClass);
                Object certificateSubjectNameObject = certificateSubjectNameConstr.newInstance(x500NameObject);
                methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "SUBJECT"), certificateSubjectNameObject);
            }
            catch (InvocationTargetException ite) {
                methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "SUBJECT"), x500NameObject);
            }
            try {
                Class<?> certificateIssuerNameClass = Class.forName(X509CertificateUtil.getCertificateIssuerNameModuleName());
                Constructor<?> certificateIssuerNameConstr = certificateIssuerNameClass.getConstructor(x500NameClass);
                Object certificateIssuerNameObject = certificateIssuerNameConstr.newInstance(x500NameObject);
                methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "ISSUER"), certificateIssuerNameObject);
            }
            catch (InvocationTargetException ite) {
                methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "ISSUER"), x500NameObject);
            }
            Class<?> certificateX509KeyClass = Class.forName(X509CertificateUtil.getCertificateX509KeyModuleName());
            Constructor<?> certificateX509KeyConstr = certificateX509KeyClass.getConstructor(PublicKey.class);
            Object certificateX509KeyObject = certificateX509KeyConstr.newInstance(pair.getPublic());
            methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "KEY"), certificateX509KeyObject);
            Class<?> certificateVersionClass = Class.forName(X509CertificateUtil.getCertificateVersionModuleName());
            Constructor<?> certificateVersionConstr = certificateVersionClass.getConstructor(Integer.TYPE);
            Constructor<?> certificateVersionConstr0 = certificateVersionClass.getConstructor(new Class[0]);
            Object certInfoObject0 = certificateVersionConstr0.newInstance(new Object[0]);
            Field v3IntField = certInfoObject0.getClass().getDeclaredField("V3");
            v3IntField.setAccessible(true);
            int fValue = v3IntField.getInt(certInfoObject0);
            Object certificateVersionObject = certificateVersionConstr.newInstance(fValue);
            methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "VERSION"), certificateVersionObject);
            Class<?> algorithmIdClass = Class.forName(X509CertificateUtil.getAlgorithmIdModuleName());
            Field md5WithRSAField = algorithmIdClass.getDeclaredField("md5WithRSAEncryption_oid");
            md5WithRSAField.setAccessible(true);
            Class<?> objectIdentifierClass = Class.forName(X509CertificateUtil.getObjectIdentifierModuleName());
            Object md5WithRSAValue = md5WithRSAField.get(algorithmIdClass);
            Constructor<?> algorithmIdConstr = algorithmIdClass.getConstructor(objectIdentifierClass);
            Object algorithmIdObject = algorithmIdConstr.newInstance(md5WithRSAValue);
            Class<?> certificateAlgorithmIdClass = Class.forName(X509CertificateUtil.getCertificateAlgorithmIdModuleName());
            Constructor<?> certificateAlgorithmIdConstr = certificateAlgorithmIdClass.getConstructor(algorithmIdClass);
            Object certificateAlgorithmIdObject = certificateAlgorithmIdConstr.newInstance(algorithmIdObject);
            methodSET.invoke(certInfoObject, X509CertificateUtil.getSetField(certInfoObject, "ALGORITHM_ID"), certificateAlgorithmIdObject);
            Class<?> x509CertImplClass = Class.forName(X509CertificateUtil.getX509CertImplModuleName());
            Constructor<?> x509CertImplConstr = x509CertImplClass.getConstructor(certInfoClass);
            x509CertImplObject = x509CertImplConstr.newInstance(certInfoObject);
            Method methoSIGN = x509CertImplObject.getClass().getMethod("sign", PrivateKey.class, String.class);
            methoSIGN.invoke(x509CertImplObject, privkey, algorithm);
            Method methoGET = x509CertImplObject.getClass().getMethod("get", String.class);
            String sig_alg = X509CertificateUtil.getSetField(x509CertImplObject, "SIG_ALG");
            String certAlgoIdNameValue = X509CertificateUtil.getSetField(certificateAlgorithmIdObject, "NAME");
            String certAlgoIdAlgoValue = X509CertificateUtil.getSetField(certificateAlgorithmIdObject, "ALGORITHM");
            methodSET.invoke(certInfoObject, certAlgoIdNameValue + "." + certAlgoIdAlgoValue, methoGET.invoke(x509CertImplObject, sig_alg));
            x509CertImplObject = x509CertImplConstr.newInstance(certInfoObject);
            methoSIGN.invoke(x509CertImplObject, privkey, algorithm);
        }
        catch (Exception e) {
            LOG.failedToGenerateCertificate(e);
        }
        return (X509Certificate)x509CertImplObject;
    }

    private static String getX509CertInfoModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.X509CertInfo" : "sun.security.x509.X509CertInfo";
    }

    private static String getX509CertifValidityModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.CertificateValidity" : "sun.security.x509.CertificateValidity";
    }

    private static String getX509X500NameModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.X500Name" : "sun.security.x509.X500Name";
    }

    private static String getCertificateSerialNumberModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.CertificateSerialNumber" : "sun.security.x509.CertificateSerialNumber";
    }

    private static String getCertificateSubjectNameModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.CertificateSubjectName" : "sun.security.x509.CertificateSubjectName";
    }

    private static String getCertificateIssuerNameModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.CertificateIssuerName" : "sun.security.x509.CertificateIssuerName";
    }

    private static String getCertificateX509KeyModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.CertificateX509Key" : "sun.security.x509.CertificateX509Key";
    }

    private static String getCertificateVersionModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.CertificateVersion" : "sun.security.x509.CertificateVersion";
    }

    private static String getAlgorithmIdModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.AlgorithmId" : "sun.security.x509.AlgorithmId";
    }

    private static String getObjectIdentifierModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.util.ObjectIdentifier" : "sun.security.util.ObjectIdentifier";
    }

    private static String getCertificateAlgorithmIdModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.CertificateAlgorithmId" : "sun.security.x509.CertificateAlgorithmId";
    }

    private static String getX509CertImplModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.x509.X509CertImpl" : "sun.security.x509.X509CertImpl";
    }

    private static String getSetField(Object obj, String setString) throws Exception {
        Field privateStringField = obj.getClass().getDeclaredField(setString);
        privateStringField.setAccessible(true);
        return (String)privateStringField.get(obj);
    }

    public static void writeCertificateToFile(Certificate cert, File file) throws CertificateEncodingException, IOException {
        byte[] bytes = cert.getEncoded();
        Base64 encoder = new Base64(76, "\n".getBytes(StandardCharsets.US_ASCII));
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write("-----BEGIN CERTIFICATE-----\n".getBytes(StandardCharsets.US_ASCII));
            out.write(encoder.encodeToString(bytes).getBytes(StandardCharsets.US_ASCII));
            out.write("-----END CERTIFICATE-----\n".getBytes(StandardCharsets.US_ASCII));
        }
    }

    public static void writeCertificateToJKS(Certificate cert, File file) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = "changeit".toCharArray();
        ks.load(null, password);
        ks.setCertificateEntry("gateway-identity", cert);
        try (FileOutputStream fos = new FileOutputStream(file);){
            ks.store(fos, password);
        }
    }
}

