/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.extractors;

import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.regex.Pattern;
import org.pac4j.scribe.model.WechatToken;

public class WechatJsonExtractor
extends OAuth2AccessTokenJsonExtractor {
    public static final Pattern OPENID_REGEX = Pattern.compile("\"openid\"\\s*:\\s*\"(\\S*?)\"");
    public static final Pattern UNION_ID_REGEX = Pattern.compile("\"unionid\"\\s*:\\s*\"(\\S*?)\"");

    protected WechatJsonExtractor() {
    }

    public static WechatJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    protected OAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String response) {
        String openid = WechatJsonExtractor.extractParameter((String)response, (Pattern)OPENID_REGEX, (boolean)true);
        String unionid = WechatJsonExtractor.extractParameter((String)response, (Pattern)UNION_ID_REGEX, (boolean)false);
        WechatToken token = new WechatToken(accessToken, tokenType, expiresIn, refreshToken, scope, response, openid, unionid);
        return token;
    }

    private static class InstanceHolder {
        private static final WechatJsonExtractor INSTANCE = new WechatJsonExtractor();

        private InstanceHolder() {
        }
    }
}

