/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.common.IsolationLevel;

public class FetchConfig {
    public final int minBytes;
    public final int maxBytes;
    public final int maxWaitMs;
    public final int fetchSize;
    public final int maxPollRecords;
    public final boolean checkCrcs;
    public final String clientRackId;
    public final IsolationLevel isolationLevel;

    public FetchConfig(int minBytes, int maxBytes, int maxWaitMs, int fetchSize, int maxPollRecords, boolean checkCrcs, String clientRackId, IsolationLevel isolationLevel) {
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
        this.maxWaitMs = maxWaitMs;
        this.fetchSize = fetchSize;
        this.maxPollRecords = maxPollRecords;
        this.checkCrcs = checkCrcs;
        this.clientRackId = clientRackId;
        this.isolationLevel = isolationLevel;
    }

    public FetchConfig(ConsumerConfig config) {
        this.minBytes = config.getInt("fetch.min.bytes");
        this.maxBytes = config.getInt("fetch.max.bytes");
        this.maxWaitMs = config.getInt("fetch.max.wait.ms");
        this.fetchSize = config.getInt("max.partition.fetch.bytes");
        this.maxPollRecords = config.getInt("max.poll.records");
        this.checkCrcs = config.getBoolean("check.crcs");
        this.clientRackId = config.getString("client.rack");
        this.isolationLevel = ConsumerUtils.configuredIsolationLevel(config);
    }

    public String toString() {
        return "FetchConfig{minBytes=" + this.minBytes + ", maxBytes=" + this.maxBytes + ", maxWaitMs=" + this.maxWaitMs + ", fetchSize=" + this.fetchSize + ", maxPollRecords=" + this.maxPollRecords + ", checkCrcs=" + this.checkCrcs + ", clientRackId='" + this.clientRackId + "', isolationLevel=" + String.valueOf((Object)this.isolationLevel) + "}";
    }
}

