/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.ExternalKRaftMetrics;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\rs!\u0002\u001f>\u0011\u0003\u0011e!\u0002#>\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003i\u0005\"\u0002(\u0002\t\u0013y\u0005\"B4\u0002\t\u0013A\u0007\"\u0002=\u0002\t\u0013Ih!\u0002#>\u0001\u0005%\u0001\"CA\u001b\r\t\u0005\t\u0015!\u0003]\u0011!qhA!A!\u0002\u0013y\bBCA\u001c\r\t\u0005\t\u0015!\u0003\u0002:!Q\u0011Q\t\u0004\u0003\u0002\u0003\u0006I!a\u0012\t\u0015\u0005UcA!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002^\u0019\u0011\t\u0011)A\u0005\u0003sA!\"a\u0018\u0007\u0005\u0003\u0005\u000b\u0011BA1\u0011)\tYG\u0002B\u0001B\u0003%\u0011Q\u000e\u0005\u000b\u0003o2!\u0011!Q\u0001\n\u0005e\u0004BCAB\r\t\u0005\t\u0015!\u0003\u0002\u0006\"Q\u00111\u0012\u0004\u0003\u0006\u0004%\t!!$\t\u0015\u0005ufA!A!\u0002\u0013\ty\t\u0003\u0006\u0002@\u001a\u0011\t\u0011)A\u0005\u0003\u0003D!\"a2\u0007\u0005\u0003\u0005\u000b\u0011BAe\u0011)\tyM\u0002B\u0001B\u0003%\u0011\u0011\u001b\u0005\u0007\u0019\u001a!\t!!8\t\u0013\u0005uhA1A\u0005\u0002\u0005}\b\u0002\u0003B\u0007\r\u0001\u0006IA!\u0001\t\u0013\t=aA1A\u0005\n\tE\u0001\u0002\u0003B\r\r\u0001\u0006IAa\u0005\t\u0013\tmaA1A\u0005\n\tu\u0001b\u0002B\u0010\r\u0001\u0006I\u0001\u0018\u0005\n\u0005C1!\u0019!C\u0005\u0005GA\u0001Ba\u000b\u0007A\u0003%!Q\u0005\u0005\n\u0005[1!\u0019!C\u0005\u0005_A\u0001Ba\u000e\u0007A\u0003%!\u0011\u0007\u0005\to\u001a\u0011\r\u0011\"\u0003\u0003:!9!1\b\u0004!\u0002\u0013\u0001\u0006\"\u0003B\u001f\r\t\u0007I\u0011\u0002B \u0011!\u0011\u0019E\u0002Q\u0001\n\t\u0005\u0003\"\u0003B#\r\t\u0007I\u0011\tB$\u0011!\u0011yE\u0002Q\u0001\n\t%\u0003\"\u0003B)\r\t\u0007I\u0011\u0002B*\u0011!\u0011YF\u0002Q\u0001\n\tU\u0003\"\u0003B/\r\t\u0007I\u0011\u0002B0\u0011!\u0011iG\u0002Q\u0001\n\t\u0005\u0004\"\u0003B8\r\t\u0007I\u0011\u0002B9\u0011!\u0011IH\u0002Q\u0001\n\tM\u0004\"\u0003B>\r\t\u0007I\u0011\tB?\u0011!\u0011)I\u0002Q\u0001\n\t}\u0004\"\u0003BD\r\t\u0007I\u0011\u0002BE\u0011!\u0011\tJ\u0002Q\u0001\n\t-\u0005b\u0002BJ\r\u0011\u0005!Q\u0013\u0005\b\u0005;3A\u0011\u0001BK\u0011\u001d\u0011yJ\u0002C!\u0005CCqA!.\u0007\t\u0003\u00129\fC\u0004\u0003p\u001a!IA!=\t\u000f\tMh\u0001\"\u0003\u0003v\"9!q\u001f\u0004\u0005\n\te\bb\u0002B~\r\u0011%!Q \u0005\b\u0007\u000b1A\u0011BB\u0004\u0011\u001d\u0019\tC\u0002C!\u0007GAqaa\u000b\u0007\t\u0003\u001ai#\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4fe*\u0011ahP\u0001\u0005e\u00064GOC\u0001A\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"aQ\u0001\u000e\u0003u\u0012\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u0014\u0005\u00051\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0005\u0006\u00112M]3bi\u0016dun\u001a#je\u0016\u001cGo\u001c:z)\r\u0001\u0006L\u0017\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000b!![8\u000b\u0003U\u000bAA[1wC&\u0011qK\u0015\u0002\u0005\r&dW\rC\u0003Z\u0007\u0001\u0007\u0001+\u0001\u0004m_\u001e$\u0015N\u001d\u0005\u00067\u000e\u0001\r\u0001X\u0001\u000bY><G)\u001b:OC6,\u0007CA/e\u001d\tq&\r\u0005\u0002`\u00116\t\u0001M\u0003\u0002b\u0003\u00061AH]8pizJ!a\u0019%\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003G\"\u000b1\u0002\\8dW\u0012\u000bG/\u0019#jeR\u0011\u0011N\u001e\t\u0003URl\u0011a\u001b\u0006\u0003Y6\fA!\u001e;jY*\u0011an\\\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0001\u0003(BA9s\u0003\u0019\t\u0007/Y2iK*\t1/A\u0002pe\u001eL!!^6\u0003\u0011\u0019KG.\u001a'pG.DQa\u001e\u0003A\u0002A\u000bq\u0001Z1uC\u0012K'/\u0001\niCN$\u0015N\u001a4fe\u0016tG\u000fT8h\t&\u0014HC\u0001>~!\t950\u0003\u0002}\u0011\n9!i\\8mK\u0006t\u0007\"\u0002@\u0006\u0001\u0004y\u0018AB2p]\u001aLw\r\u0005\u0003\u0002\u0002\u0005\u0015QBAA\u0002\u0015\tqw(\u0003\u0003\u0002\b\u0005\r!aC&bM.\f7i\u001c8gS\u001e,B!a\u0003\u0002\u0018M1aARA\u0007\u0003S\u0001RaQA\b\u0003'I1!!\u0005>\u0005-\u0011\u0016M\u001a;NC:\fw-\u001a:\u0011\t\u0005U\u0011q\u0003\u0007\u0001\t\u001d\tIB\u0002b\u0001\u00037\u0011\u0011\u0001V\t\u0005\u0003;\t\u0019\u0003E\u0002H\u0003?I1!!\tI\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aRA\u0013\u0013\r\t9\u0003\u0013\u0002\u0004\u0003:L\b\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=r(A\u0003vi&d7/\u0003\u0003\u00024\u00055\"a\u0002'pO\u001eLgnZ\u0001\nG2,8\u000f^3s\u0013\u0012\f!#\\3uC\u0012\fG/\u0019'pO\u0012K'/V;jIB!\u00111HA!\u001b\t\tiDC\u0002\u0002@=\faaY8n[>t\u0017\u0002BA\"\u0003{\u0011A!V;jI\u0006Y!/Z2pe\u0012\u001cVM\u001d3f!\u0019\tI%!\u0015\u0002\u00145\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0004\u0003\u007fi\u0017\u0002BA*\u0003\u0017\u00121BU3d_J$7+\u001a:eK\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA\u001e\u00033JA!a\u0017\u0002>\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0002;pa&\u001c\u0017\nZ\u0001\u0005i&lW\r\u0005\u0003\u0002d\u0005\u001dTBAA3\u0015\u0011\ty#!\u0010\n\t\u0005%\u0014Q\r\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\t\u0005=\u00141O\u0007\u0003\u0003cRA!a\u001b\u0002>%!\u0011QOA9\u0005\u001diU\r\u001e:jGN\fA#\u001a=uKJt\u0017\r\\&SC\u001a$X*\u001a;sS\u000e\u001c\b\u0003BA>\u0003\u007fj!!! \u000b\u0005yz\u0017\u0002BAA\u0003{\u0012A#\u0012=uKJt\u0017\r\\&SC\u001a$X*\u001a;sS\u000e\u001c\u0018a\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y\u001fB$\b\u0003B$\u0002\brK1!!#I\u0005\u0019y\u0005\u000f^5p]\u0006a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAAH!\u0019\t\t*!'\u0002\u001e6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\u001c+\n\t\u0005m\u00151\u0013\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CAP\u0003C\u000b)+!-\u000e\u0005\u0005]\u0015\u0002BAR\u0003/\u00131!T1q!\u0011\t9+!,\u000e\u0005\u0005%&bAAV)\u0006!A.\u00198h\u0013\u0011\ty+!+\u0003\u000f%sG/Z4feB!\u00111WA]\u001b\t\t)LC\u0002\u00028R\u000b1A\\3u\u0013\u0011\tY,!.\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8/A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000f\u0005\u0004\u0002 \u0006\r\u0017\u0011W\u0005\u0005\u0003\u000b\f9J\u0001\u0006D_2dWm\u0019;j_:\fa\u0002\\8dC2d\u0015n\u001d;f]\u0016\u00148\u000f\u0005\u0003\u0002|\u0005-\u0017\u0002BAg\u0003{\u0012\u0011\"\u00128ea>Lg\u000e^:\u0002#\u0019\fG/\u00197GCVdG\u000fS1oI2,'\u000f\u0005\u0003\u0002T\u0006eWBAAk\u0015\r\t9.\\\u0001\u0006M\u0006,H\u000e^\u0005\u0005\u00037\f)N\u0001\u0007GCVdG\u000fS1oI2,'\u000f\u0006\u0010\u0002`\u0006\u0005\u00181]As\u0003O\fI/a;\u0002n\u0006=\u0018\u0011_Az\u0003k\f90!?\u0002|B!1IBA\n\u0011\u0019\t)D\u0006a\u00019\")aP\u0006a\u0001\u007f\"9\u0011q\u0007\fA\u0002\u0005e\u0002bBA#-\u0001\u0007\u0011q\t\u0005\b\u0003+2\u0002\u0019AA,\u0011\u001d\tiF\u0006a\u0001\u0003sAq!a\u0018\u0017\u0001\u0004\t\t\u0007C\u0004\u0002lY\u0001\r!!\u001c\t\u000f\u0005]d\u00031\u0001\u0002z!9\u00111\u0011\fA\u0002\u0005\u0015\u0005bBAF-\u0001\u0007\u0011q\u0012\u0005\b\u0003\u007f3\u0002\u0019AAa\u0011\u001d\t9M\u0006a\u0001\u0003\u0013Dq!a4\u0017\u0001\u0004\t\t.A\u0006ba&4VM]:j_:\u001cXC\u0001B\u0001!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!b\u0001B\u0004_\u000691\r\\5f]R\u001c\u0018\u0002\u0002B\u0006\u0005\u000b\u00111\"\u00119j-\u0016\u00148/[8og\u0006a\u0011\r]5WKJ\u001c\u0018n\u001c8tA\u0005Q!/\u00194u\u0007>tg-[4\u0016\u0005\tM\u0001\u0003BA>\u0005+IAAa\u0006\u0002~\ta\u0011+^8sk6\u001cuN\u001c4jO\u0006Y!/\u00194u\u0007>tg-[4!\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001]\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u000bY><7i\u001c8uKb$XC\u0001B\u0013!\u0011\t\u0019Ga\n\n\t\t%\u0012Q\r\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\tE\u0002c\u00016\u00034%\u0019!QG6\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0016\u0003A\u000b\u0001\u0002Z1uC\u0012K'\u000fI\u0001\fI\u0006$\u0018\rR5s\u0019>\u001c7.\u0006\u0002\u0003BA!q)a\"j\u00031!\u0017\r^1ESJdunY6!\u00035\u0011X\r\u001d7jG\u0006$X\r\u001a'pOV\u0011!\u0011\n\t\u0005\u0003w\u0012Y%\u0003\u0003\u0003N\u0005u$!\u0004*fa2L7-\u0019;fI2{w-\u0001\bsKBd\u0017nY1uK\u0012dun\u001a\u0011\u0002\u00159,Go\u00115b]:,G.\u0006\u0002\u0003VA!\u00111\u0010B,\u0013\u0011\u0011I&! \u0003'-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7\u0002\u00179,Go\u00115b]:,G\u000eI\u0001\u0010Kb\u0004\u0018N]1uS>tG+[7feV\u0011!\u0011\r\t\u0005\u0005G\u0012I'\u0004\u0002\u0003f)\u0019!qM6\u0002\u000bQLW.\u001a:\n\t\t-$Q\r\u0002\f'f\u001cH/Z7US6,'/\u0001\tfqBL'/\u0019;j_:$\u0016.\\3sA\u0005\tR\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u0005\tM\u0004cA\"\u0003v%\u0019!qO\u001f\u00039QKW.\u001b8h/\",W\r\\#ya&\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011R\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3!\u0003\u0019\u0019G.[3oiV\u0011!q\u0010\t\u0007\u0003w\u0012\t)a\u0005\n\t\t\r\u0015Q\u0010\u0002\u0010\u0017\u000647.\u0019*bMR\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013\u0001D2mS\u0016tG\u000f\u0012:jm\u0016\u0014XC\u0001BF!\u0019\tYH!$\u0002\u0014%!!qRA?\u0005UY\u0015MZ6b%\u00064Go\u00117jK:$HI]5wKJ\fQb\u00197jK:$HI]5wKJ\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u0003\u0005/\u00032a\u0012BM\u0013\r\u0011Y\n\u0013\u0002\u0005+:LG/\u0001\u0005tQV$Hm\\<o\u0003!\u0011XmZ5ti\u0016\u0014H\u0003\u0002BL\u0005GCqA!*4\u0001\u0004\u00119+\u0001\u0005mSN$XM\\3s!\u0019\u0011IKa,\u0002\u00149!\u00111\u0010BV\u0013\u0011\u0011i+! \u0002\u0015I\u000bg\r^\"mS\u0016tG/\u0003\u0003\u00032\nM&\u0001\u0003'jgR,g.\u001a:\u000b\t\t5\u0016QP\u0001\u000eQ\u0006tG\r\\3SKF,Xm\u001d;\u0015\u0015\te&q\u0019Bl\u0005C\u0014)\u000f\u0005\u0004\u0002\u0012\u0006e%1\u0018\t\u0005\u0005{\u0013\u0019-\u0004\u0002\u0003@*!!\u0011YA\u001f\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002Bc\u0005\u007f\u0013!\"\u00119j\u001b\u0016\u001c8/Y4f\u0011\u001d\u0011I\r\u000ea\u0001\u0005\u0017\fqaY8oi\u0016DH\u000f\u0005\u0003\u0003N\nMWB\u0001Bh\u0015\u0011\u0011\t.!\u0010\u0002\u0011I,\u0017/^3tiNLAA!6\u0003P\nq!+Z9vKN$8i\u001c8uKb$\bb\u0002Bmi\u0001\u0007!1\\\u0001\u0007Q\u0016\fG-\u001a:\u0011\t\t5'Q\\\u0005\u0005\u0005?\u0014yMA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\b\u0005G$\u0004\u0019\u0001B^\u0003\u001d\u0011X-];fgRDqAa:5\u0001\u0004\u0011I/A\u0007de\u0016\fG/\u001a3US6,Wj\u001d\t\u0004\u000f\n-\u0018b\u0001Bw\u0011\n!Aj\u001c8h\u0003=\u0011W/\u001b7e%\u00064Go\u00117jK:$HC\u0001B@\u0003M\u0011W/\u001b7e\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m)\t\u0011)&A\u0007de\u0016\fG/\u001a#bi\u0006$\u0015N\u001d\u000b\u0002!\u0006\u0001\"-^5mI6+G/\u00193bi\u0006dun\u001a\u000b\u0003\u0005\u007f\u00042aQB\u0001\u0013\r\u0019\u0019!\u0010\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e\f!CY;jY\u0012tU\r^<pe.\u001cE.[3oiR\u00111\u0011\u0002\t\b\u000f\u000e-1qBB\u000e\u0013\r\u0019i\u0001\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\rE1qC\u0007\u0003\u0007'QAa!\u0006\u0002>\u00059a.\u001a;x_J\\\u0017\u0002BB\r\u0007'\u0011A\u0002T5ti\u0016tWM\u001d(b[\u0016\u0004BAa\u0001\u0004\u001e%!1q\u0004B\u0003\u00055qU\r^<pe.\u001cE.[3oi\u0006qA.Z1eKJ\fe\u000eZ#q_\u000eDWCAB\u0013!\u0011\tYha\n\n\t\r%\u0012Q\u0010\u0002\u000f\u0019\u0016\fG-\u001a:B]\u0012,\u0005o\\2i\u0003%1x\u000e^3s\u001d>$W\r\u0006\u0004\u00040\r]2\u0011\t\t\u0006\u000f\u0006\u001d5\u0011\u0007\t\u0005\u0003w\u0019\u0019$\u0003\u0003\u00046\u0005u\"\u0001\u0002(pI\u0016Dqa!\u000f<\u0001\u0004\u0019Y$\u0001\u0002jIB\u0019qi!\u0010\n\u0007\r}\u0002JA\u0002J]RDqA!*<\u0001\u0004\u0019y\u0001")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final ExternalKRaftMetrics externalKRaftMetrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final Endpoints localListeners;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    public void startup() {
        this.client().initialize(this.controllerQuorumVotersFuture().get(), (QuorumStateStore)new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics, this.externalKRaftMetrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
        Utils.closeQuietly((AutoCloseable)this.expirationTimer(), (String)"expiration timer");
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.clientDriver().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
        Utils.closeQuietly((AutoCloseable)this.netChannel(), (String)"net channel");
        Utils.closeQuietly((AutoCloseable)this.replicatedLog(), (String)"replicated log");
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$2 -> {
            x$2.destroy();
            return BoxedUnit.UNIT;
        }), this, Level.WARN);
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestContext context, RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(context, header, request, createdTimeMs);
    }

    private KafkaRaftClient<T> buildRaftClient() {
        return new KafkaRaftClient(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), this.time, (ExpirationService)this.expirationService(), this.logContext(), this.config.processRoles().contains((Object)ProcessRole.ControllerRole), this.clusterId, this.bootstrapServers, this.localListeners, Feature.KRAFT_VERSION.supportedVersionRange(), this.raftConfig());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaNetworkChannel buildNetworkChannel() {
        void var3_3;
        void var2_2;
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)tuple2._1();
        NetworkClient netClient = (NetworkClient)tuple2._2();
        return new KafkaNetworkChannel(this.time, (ListenerName)var2_2, (KafkaClient)var3_3, this.config.quorumConfig().requestTimeoutMs(), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog.logDirName((TopicPartition)logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = "raft-client-" + this.config.nodeId();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), this.config.quorumConfig().requestTimeoutMs(), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2((Object)controllerListenerName, (Object)networkClient);
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    @Override
    public Option<Node> voterNode(int id, ListenerName listener) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.client().voterNode(id, listener)));
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, ExternalKRaftMetrics externalKRaftMetrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, Endpoints localListeners, FaultHandler fatalFaultHandler) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.externalKRaftMetrics = externalKRaftMetrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.localListeners = localListeners;
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext("[RaftManager id=" + config.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, this.threadNamePrefix() + "-scheduler");
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
    }
}

