/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.BaseKey;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.coordinator.transaction.UnknownKey;
import kafka.log.UnifiedLog;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r=d\u0001B\u001b7\u0001uB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003d\u0011!1\u0007A!A!\u0002\u00139\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011M\u0004!\u0011!Q\u0001\nQDQ!\u001f\u0001\u0005\u0002i,a!a\u0002\u0001\t\u0005%\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\t9\u0005\u0001Q\u0001\n\u0005E\u0002\"CA%\u0001\t\u0007I\u0011BA&\u0011!\tI\u0006\u0001Q\u0001\n\u00055\u0003BCA.\u0001\t\u0007I\u0011\u0001\u001c\u0002^!A\u0011Q\u000f\u0001!\u0002\u0013\ty\u0006\u0003\u0006\u0002x\u0001\u0011\r\u0011\"\u00017\u0003sB\u0001\"a\"\u0001A\u0003%\u00111\u0010\u0005\f\u0003\u0013\u0003\u0001\u0019!a\u0001\n\u0013\tY\tC\u0006\u0002\u0014\u0002\u0001\r\u00111A\u0005\n\u0005U\u0005bCAN\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001bC1\"!(\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002 \"Y\u0011\u0011\u0015\u0001A\u0002\u0003\u0007I\u0011BAR\u0011)\t9\u000b\u0001a\u0001\u0002\u0003\u0006Ka\u0013\u0005\n\u0003c\u0003!\u0019!C\u0005\u0003gC\u0001\"a/\u0001A\u0003%\u0011Q\u0017\u0005\t\u0003{\u0003A\u0011\u0001\u001c\u0002@\"A\u00111\u001a\u0001\u0005\u0002Y\ni\rC\u0004\u0002X\u0002!\t!!7\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"9!Q\u0002\u0001\u0005\n\t=\u0001b\u0002B\u0013\u0001\u0011%!q\u0005\u0005\t\u0003s\u0004A\u0011\u0001\u001c\u0003>!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B.\u0001\u0011\u0005!Q\b\u0005\b\u0005;\u0002A\u0011\u0001B0\u0011\u001d\u0011\u0019\n\u0001C\u0001\u0005+CqAa'\u0001\t\u0003\u0011i\nC\u0004\u0003>\u0002!IAa0\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!\u0011\u001b\u0001\u0005\u0002\tM\u0007b\u0002Bo\u0001\u0011\u0005!q\u001c\u0005\b\u0005G\u0004A\u0011\u0002Bs\u0011!\u0011\u0019\u0010\u0001C\u0001m\tU\bbBB\u0001\u0001\u0011\u000511\u0001\u0005\b\u0007#\u0001A\u0011AB\n\u0011\u001d\u0019\t\u0002\u0001C\u0001\u0007/Aqa!\b\u0001\t\u0013\u0019y\u0002C\u0004\u0004&\u0001!IA!\u0010\t\u000f\r\u001d\u0002\u0001\"\u0001\u0004*!I1Q\n\u0001\u0012\u0002\u0013\u00051q\n\u0005\b\u0007K\u0002A\u0011AB4\u0011\u001d\u0019i\u0007\u0001C\u0001\u0005{\u0011q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u000b\u0005]B\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u000f\u001e\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002w\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001?\tB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u001e\u0002\u000bU$\u0018\u000e\\:\n\u0005%3%a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JIB\u0011q\bT\u0005\u0003\u001b\u0002\u00131!\u00138u\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002Q56\t\u0011K\u0003\u0002S'\u0006!Q\u000f^5m\u0015\t!V+\u0001\u0004tKJ4XM\u001d\u0006\u0003wYS!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO&\u00111,\u0015\u0002\n'\u000eDW\rZ;mKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002_A6\tqL\u0003\u0002Uu%\u0011\u0011m\u0018\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u00035iW\r^1eCR\f7)Y2iKB\u0011a\fZ\u0005\u0003K~\u0013Q\"T3uC\u0012\fG/Y\"bG\",\u0017AB2p]\u001aLw\r\u0005\u0002iS6\ta'\u0003\u0002km\t\tBK]1og\u0006\u001cG/[8o\u0007>tg-[4\u0002\tQLW.\u001a\t\u0003[Fl\u0011A\u001c\u0006\u0003\u000f>T!\u0001]+\u0002\r\r|W.\\8o\u0013\t\u0011hN\u0001\u0003US6,\u0017aB7fiJL7m\u001d\t\u0003k^l\u0011A\u001e\u0006\u0003g>L!\u0001\u001f<\u0003\u000f5+GO]5dg\u00061A(\u001b8jiz\"2b\u001f?~}~\f\t!a\u0001\u0002\u0006A\u0011\u0001\u000e\u0001\u0005\u0006\u0015\"\u0001\ra\u0013\u0005\u0006\u001d\"\u0001\ra\u0014\u0005\u00069\"\u0001\r!\u0018\u0005\u0006E\"\u0001\ra\u0019\u0005\u0006M\"\u0001\ra\u001a\u0005\u0006W\"\u0001\r\u0001\u001c\u0005\u0006g\"\u0001\r\u0001\u001e\u0002\u0017'\u0016tG\r\u0016=o\u001b\u0006\u00148.\u001a:t\u0007\u0006dGNY1dWBaq(a\u0003L\u0003\u001f\tY\"!\t\u0002(%\u0019\u0011Q\u0002!\u0003\u0013\u0019+hn\u0019;j_:$\u0004\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005Uq.\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tI\"a\u0005\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG\u000fE\u0002i\u0003;I1!a\b7\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\rA\u00171E\u0005\u0004\u0003K1$A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006\u00042aPA\u0015\u0013\r\tY\u0003\u0011\u0002\u0005+:LG/\u0001\u0007tQV$H/\u001b8h\t><h.\u0006\u0002\u00022A!\u00111GA\"\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012AB1u_6L7M\u0003\u0003\u0002<\u0005u\u0012AC2p]\u000e,(O]3oi*\u0019!+a\u0010\u000b\u0005\u0005\u0005\u0013\u0001\u00026bm\u0006LA!!\u0012\u00026\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fQb\u001d5viRLgn\u001a#po:\u0004\u0013!C:uCR,Gj\\2l+\t\ti\u0005\u0005\u0003\u0002P\u0005USBAA)\u0015\u0011\t\u0019&!\u000f\u0002\u000b1|7m[:\n\t\u0005]\u0013\u0011\u000b\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006Q1\u000f^1uK2{7m\u001b\u0011\u0002#1|\u0017\rZ5oOB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002`A1\u0011\u0011MA6\u0003_j!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\b[V$\u0018M\u00197f\u0015\r\tI\u0007Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA7\u0003G\u00121aU3u!\rA\u0017\u0011O\u0005\u0004\u0003g2$A\t+sC:\u001c\u0018m\u0019;j_:\u0004\u0016M\u001d;ji&|g.\u00118e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u0001\nm_\u0006$\u0017N\\4QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u0007;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f7)Y2iKV\u0011\u00111\u0010\t\b\u0003C\nihSAA\u0013\u0011\ty(a\u0019\u0003\u00075\u000b\u0007\u000fE\u0002i\u0003\u0007K1!!\"7\u0005U!\u0006P\\'fi\u0006$\u0017\r^1DC\u000eDW-\u00128uef\f\u0011\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\u0015m\u00195fA\u00051#/\u001a;sS\u00164X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0016\u0005\u00055\u0005\u0003B \u0002\u0010.K1!!%A\u0005%1UO\\2uS>t\u0007'\u0001\u0016sKR\u0014\u0018.\u001a<f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R|F%Z9\u0015\t\u0005\u001d\u0012q\u0013\u0005\n\u00033\u001b\u0012\u0011!a\u0001\u0003\u001b\u000b1\u0001\u001f\u00132\u0003\u001d\u0012X\r\u001e:jKZ,GK]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\u0011\u0002=Q\u0014\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$X#A&\u0002EQ\u0014\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$x\fJ3r)\u0011\t9#!*\t\u0011\u0005ee#!AA\u0002-\u000bq\u0004\u001e:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;!Q\r9\u00121\u0016\t\u0004\u007f\u00055\u0016bAAX\u0001\nAao\u001c7bi&dW-A\nqCJ$\u0018\u000e^5p]2{\u0017\rZ*f]N|'/\u0006\u0002\u00026B\u0019Q/a.\n\u0007\u0005efO\u0001\u0004TK:\u001cxN]\u0001\u0015a\u0006\u0014H/\u001b;j_:du.\u00193TK:\u001cxN\u001d\u0011\u0002/Q\u0014\u0018M\\:bGRLwN\u001c,feNLwN\u001c'fm\u0016dGCAAa!\u0011\t\u0019-a2\u000e\u0005\u0005\u0015'B\u00019T\u0013\u0011\tI-!2\u0003%Q\u0013\u0018M\\:bGRLwN\u001c,feNLwN\\\u0001\u0014C\u0012$Gj\\1eS:<\u0007+\u0019:uSRLwN\u001c\u000b\u0007\u0003O\ty-a5\t\r\u0005E7\u00041\u0001L\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\r\u0005U7\u00041\u0001L\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.\u0001\u000buS6,GmT;u)J\fgn]1di&|gn\u001d\u000b\u0003\u00037\u0004b!!8\u0002n\u0006Mh\u0002BAp\u0003StA!!9\u0002h6\u0011\u00111\u001d\u0006\u0004\u0003Kd\u0014A\u0002\u001fs_>$h(C\u0001B\u0013\r\tY\u000fQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty/!=\u0003\u0011%#XM]1cY\u0016T1!a;A!\rA\u0017Q_\u0005\u0004\u0003o4$!\t+sC:\u001c\u0018m\u0019;j_:\fG.\u00133B]\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#q_\u000eD\u0017!\b:f[>4X-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0015\r\u0005\u001d\u0012Q B\u0005\u0011\u001d\ty0\ba\u0001\u0005\u0003\tA\u0003\u001e:b]N\f7\r^5p]B\u000b'\u000f^5uS>t\u0007\u0003\u0002B\u0002\u0005\u000bi\u0011a\\\u0005\u0004\u0005\u000fy'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005\u0017i\u0002\u0019AAA\u0003U!\bP\\'fi\u0006$\u0017\r^1DC\u000eDW-\u00128uef\fAb\u001d5pk2$W\t\u001f9je\u0016$bA!\u0005\u0003\u0018\tm\u0001cA \u0003\u0014%\u0019!Q\u0003!\u0003\u000f\t{w\u000e\\3b]\"9!\u0011\u0004\u0010A\u0002\u0005m\u0011a\u0003;y]6+G/\u00193bi\u0006DqA!\b\u001f\u0001\u0004\u0011y\"A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\t\u0004\u007f\t\u0005\u0012b\u0001B\u0012\u0001\n!Aj\u001c8h\u0003Ui\u0017-\u001f2f\u0003B\u0004XM\u001c3FqBL'/\u0019;j_:$\u0002B!\u0005\u0003*\t-\"1\b\u0005\b\u00053y\u0002\u0019AA\u000e\u0011\u001d\u0011ic\ba\u0001\u0005_\taB]3d_J$7OQ;jY\u0012,'\u000f\u0005\u0003\u00032\t]RB\u0001B\u001a\u0015\r\u0011)d\\\u0001\u0007e\u0016\u001cwN\u001d3\n\t\te\"1\u0007\u0002\u0015\u001b\u0016lwN]=SK\u000e|'\u000fZ:Ck&dG-\u001a:\t\u000f\tuq\u00041\u0001\u0003 Q\u0011\u0011qE\u0001*oJLG/\u001a+p[\n\u001cHo\u001c8fg\u001a{'/\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0015\u0011\u0005\u001d\"1\tB#\u0005#Bq!a@\"\u0001\u0004\u0011\t\u0001C\u0004\u0003H\u0005\u0002\rA!\u0013\u0002'\u0015D\b/\u001b:fI\u001a{'\u000fU1si&$\u0018n\u001c8\u0011\r\u0005u\u0017Q\u001eB&!\rA'QJ\u0005\u0004\u0005\u001f2$A\u000b+sC:\u001c\u0018m\u0019;j_:\fG.\u00133D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006sG-T3uC\u0012\fG/\u0019\u0005\b\u0005'\n\u0003\u0019\u0001B+\u0003A!x.\u001c2ti>tWMU3d_J$7\u000f\u0005\u0003\u00032\t]\u0013\u0002\u0002B-\u0005g\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\u0018aH3oC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]\u0006\u0019r-\u001a;Ue\u0006t7/Y2uS>t7\u000b^1uKR!!\u0011\rB@!!\tiNa\u0019\u0003h\tM\u0014\u0002\u0002B3\u0003c\u0014a!R5uQ\u0016\u0014\b\u0003\u0002B5\u0005_j!Aa\u001b\u000b\u0007\t5t.\u0001\u0005qe>$xnY8m\u0013\u0011\u0011\tHa\u001b\u0003\r\u0015\u0013(o\u001c:t!\u0015y$Q\u000fB=\u0013\r\u00119\b\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007!\u0014Y(C\u0002\u0003~Y\u0012adQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195B]\u0012$\u0006P\\'fi\u0006$\u0017\r^1\t\u000f\t\u00055\u00051\u0001\u0003\u0004\u0006yAO]1og\u0006\u001cG/[8oC2LE\r\u0005\u0003\u0003\u0006\n5e\u0002\u0002BD\u0005\u0013\u00032!!9A\u0013\r\u0011Y\tQ\u0001\u0007!J,G-\u001a4\n\t\t=%\u0011\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t-\u0005)\u0001\u0010qkR$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-\u00134O_R,\u00050[:ugR!!q\u0013BM!!\tiNa\u0019\u0003h\te\u0004b\u0002B\rI\u0001\u0007\u00111D\u0001\u0016Y&\u001cH\u000f\u0016:b]N\f7\r^5p]N#\u0018\r^3t)!\u0011yJa+\u00034\ne\u0006\u0003\u0002BQ\u0005Ok!Aa)\u000b\u0007\t\u0015v.A\u0004nKN\u001c\u0018mZ3\n\t\t%&1\u0015\u0002\u001d\u0019&\u001cH\u000f\u0016:b]N\f7\r^5p]N\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0011i+\na\u0001\u0005_\u000b\u0011CZ5mi\u0016\u0014\bK]8ek\u000e,'/\u00133t!\u0019\u0011)I!-\u0003 %!\u0011Q\u000eBI\u0011\u001d\u0011),\na\u0001\u0005o\u000b\u0001CZ5mi\u0016\u00148\u000b^1uK:\u000bW.Z:\u0011\r\t\u0015%\u0011\u0017BB\u0011\u001d\u0011Y,\na\u0001\u0005?\t\u0001CZ5mi\u0016\u0014H)\u001e:bi&|g.T:\u0002=\u001d,G/\u00118e\u001b\u0006L(-Z!eIR\u0013\u0018M\\:bGRLwN\\*uCR,GC\u0002B1\u0005\u0003\u0014\u0019\rC\u0004\u0003\u0002\u001a\u0002\rAa!\t\u000f\t\u0015g\u00051\u0001\u0003H\u0006)2M]3bi\u0016$G\u000b\u001f8NKR\fG-\u0019;b\u001fB$\b#B \u0003v\u0005m\u0011\u0001\b<bY&$\u0017\r^3Ue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u000b\u0005\u0005#\u0011i\r\u0003\u0004\u0003P\u001e\u0002\raS\u0001\ribtG+[7f_V$Xj]\u0001\u0018iJ\fgn]1di&|g\u000eV8qS\u000e\u001cuN\u001c4jON,\"A!6\u0011\t\t]'\u0011\\\u0007\u0003\u0003{IAAa7\u0002>\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\u0007-\u0013\t\u000fC\u0004\u0003\u0002&\u0002\rAa!\u0002/1|\u0017\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fGC\u0002Bt\u0005[\u0014\t\u0010E\u0004F\u0005S\u0014\u0019)a\u0007\n\u0007\t-hI\u0001\u0003Q_>d\u0007b\u0002BxU\u0001\u0007!\u0011A\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t)N\u000ba\u0001\u0017\u0006a\u0012\r\u001a3M_\u0006$W\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHk\\\"bG\",G\u0003CA\u0014\u0005o\u0014YP!@\t\r\te8\u00061\u0001L\u0003E!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003+\\\u0003\u0019A&\t\u000f\t}8\u00061\u0001\u0003h\u0006\u0011Bn\\1eK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t\u0003\u0011bw.\u00193Ue\u0006t7/Y2uS>t7OR8s)btGk\u001c9jGB\u000b'\u000f^5uS>tG\u0003CA\u0014\u0007\u000b\u00199a!\u0003\t\r\u0005EG\u00061\u0001L\u0011\u0019\t)\u000e\fa\u0001\u0017\"911\u0002\u0017A\u0002\r5\u0011AD:f]\u0012$\u0006P\\'be.,'o\u001d\t\u0004\u0007\u001fIQ\"\u0001\u0001\u0002MI,Wn\u001c<f)J\fgn]1di&|gn\u001d$peRCh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002(\rU\u0001BBAi[\u0001\u00071\n\u0006\u0004\u0002(\re11\u0004\u0005\u0007\u0003#t\u0003\u0019A&\t\r\u0005Ug\u00061\u0001L\u0003}\u0011X-\\8wK2{\u0017\rZ5oOB\u000b'\u000f^5uS>tw+\u001b;i\u000bB|7\r\u001b\u000b\u0007\u0003O\u0019\tca\t\t\r\u0005Ew\u00061\u0001L\u0011\u0019\t)n\fa\u0001\u0017\u0006qc/\u00197jI\u0006$X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;JgN#\u0018M\u00197f\u0003Y\t\u0007\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><GCDA\u0014\u0007W\u0019ica\f\u00044\ru21\t\u0005\b\u0005\u0003\u000b\u0004\u0019\u0001BB\u0011\u0019\t).\ra\u0001\u0017\"91\u0011G\u0019A\u0002\u0005\u0005\u0012a\u00038fo6+G/\u00193bi\u0006Dqa!\u000e2\u0001\u0004\u00199$\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB9qh!\u000f\u0003h\u0005\u001d\u0012bAB\u001e\u0001\nIa)\u001e8di&|g.\r\u0005\n\u0007\u007f\t\u0004\u0013!a\u0001\u0007\u0003\nAB]3uef|e.\u0012:s_J\u0004raPB\u001d\u0005O\u0012\t\u0002C\u0004\u0004FE\u0002\raa\u0012\u0002\u0019I,\u0017/^3ti2{7-\u00197\u0011\t\u0005\r7\u0011J\u0005\u0005\u0007\u0017\n)M\u0001\u0007SKF,Xm\u001d;M_\u000e\fG.\u0001\u0011baB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8hI\u0011,g-Y;mi\u0012*TCAB)U\u0011\u0019\tea\u0015,\u0005\rU\u0003\u0003BB,\u0007Cj!a!\u0017\u000b\t\rm3QL\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u0018A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007G\u001aIFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqa\u001d;beR,\b\u000f\u0006\u0004\u0002(\r%41\u000e\u0005\b\u0003\u0013\u001b\u0004\u0019AAG\u0011\u001d\u0011Yf\ra\u0001\u0005#\t\u0001b\u001d5vi\u0012|wO\u001c")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final MetadataCache metadataCache;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public TransactionVersion transactionVersionLevel() {
        short fromFeatureLevel_version = Predef$.MODULE$.Short2short(this.metadataCache.features().finalizedFeatures().getOrDefault("transaction.version", Predef$.MODULE$.short2Short((short)0)));
        return (TransactionVersion)Feature.TRANSACTION_VERSION.fromFeatureLevel(fromFeatureLevel_version, true);
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    public void removeExpiredTransactionalIds() {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$7(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", () -> this.removeExpiredTransactionalIds(), (long)this.config.removeExpiredTransactionalIdsIntervalMs(), (long)this.config.removeExpiredTransactionalIdsIntervalMs());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable)x$3 -> (CoordinatorEpochAndTxnMetadata)x$3.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Unexpected empty transaction metadata returned while putting " + txnMetadata);
        }));
    }

    public ListTransactionsResponseData listTransactionStates(scala.collection.immutable.Set<Object> filterProducerIds, scala.collection.immutable.Set<String> filterStateNames, long filterDurationMs) {
        ListTransactionsResponseData listTransactionsResponseData;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            listTransactionsResponseData = TransactionStateManager.$anonfun$listTransactionStates$1(this, filterStateNames, filterProducerIds, filterDurationMs);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return listTransactionsResponseData;
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    public Properties transactionTopicConfigs() {
        Properties props = new Properties();
        props.put("unclean.leader.election.enable", "false");
        props.put("compression.type", BrokerCompressionType.UNCOMPRESSED.name);
        props.put("cleanup.policy", "compact");
        props.put("min.insync.replicas", Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put("segment.bytes", Integer.toString(this.config.transactionLogSegmentBytes()));
        return props;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)None$.MODULE$);
        Option<UnifiedLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempted to load transaction metadata from " + topicPartition + ", but found no log");
        } else if (option instanceof Some) {
            UnifiedLog log = (UnifiedLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var15_14 = null;
                    Object var16_15 = null;
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchIsolation.LOG_END, true);
                    readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                    Records records = fetchDataInfo.records;
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> "Loaded transaction metadata from " + topicPartition + " with buffer larger (" + bytesNeeded + " bytes) than configured transaction.state.log.load.buffer.size (" + $this.config.transactionLogLoadBufferSize() + " bytes)");
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> {
                        CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                            Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Transaction state log's key should not be null");
                            BaseKey baseKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
                            if (baseKey instanceof TxnKey) {
                                String transactionalId = ((TxnKey)baseKey).transactionalId();
                                Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
                                if (None$.MODULE$.equals(option)) {
                                    return (TransactionMetadata)loadedTransactions.remove(transactionalId);
                                }
                                if (option instanceof Some) {
                                    TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
                                    return loadedTransactions.put(transactionalId, txnMetadata);
                                }
                                throw new MatchError(option);
                            }
                            if (baseKey instanceof UnknownKey) {
                                UnknownKey unknownKey = (UnknownKey)baseKey;
                                this.warn((Function0<String>)(Function0 & Serializable)() -> "Unknown message key with version " + unknownKey.version() + " while loading transaction state from " + topicPartition + ". Ignoring it. It could be a left over from an aborted upgrade.");
                                return BoxedUnit.UNIT;
                            }
                            throw new MatchError((Object)baseKey);
                        });
                        currOffset$1.elem = batch.nextOffset();
                    });
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Error loading transactions from transaction log " + topicPartition, (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Unloaded transaction metadata " + previousTxnMetadataCacheEntry + " from " + txnTopicPartition$1 + " as part of loading metadata at epoch " + coordinatorEpoch$2);
            return BoxedUnit.UNIT;
        });
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var8_6 = null;
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.scheduleOnce("load-txns-for-partition-" + topicPartition, () -> this.loadTransactions$1(Predef$.MODULE$.long2Long(scheduleStartMs), topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, partitionId, sendTxnMarkers));
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionId, coordinatorEpoch, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void removeLoadingPartitionWithEpoch(int partitionId, int coordinatorEpoch) {
        this.loadingPartitions().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeLoadingPartitionWithEpoch$1(partitionId, x$8))).foreach((Function1 & Serializable)partitionAndLeaderEpoch -> {
            TransactionStateManager.$anonfun$removeLoadingPartitionWithEpoch$2(this, coordinatorEpoch, partitionAndLeaderEpoch);
            return BoxedUnit.UNIT;
        });
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException("Transaction topic number of partitions has changed from " + previouslyDeterminedPartitionCount + " to " + curTransactionTopicPartitionCount);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError, RequestLocal requestLocal) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata, this.transactionVersionLevel());
        timestamp = this.time.milliseconds();
        var17_10 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compression = TransactionLog$.MODULE$.EnforcedCompression();
        withRecords_magic = 2;
        var21_13 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        var21_13 = null;
        var16_11 = null;
        var17_10 = null;
        records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block10: {
                block9: {
                    var22_19 = false;
                    var23_20 = null;
                    var24_21 = this.getTransactionState(transactionalId);
                    if (!(var24_21 instanceof Left)) break block9;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var24_21).value();
                    (BoxedUnit)responseCallback.apply((Object)$anonfun$appendTransactionToLog$13_err);
                    break block10;
                }
                if (!(var24_21 instanceof Right)) ** GOTO lbl-1000
                var22_19 = true;
                var23_20 = (Right)var24_21;
                var26_23 = (Option)var23_20.value();
                if (None$.MODULE$.equals(var26_23)) {
                    (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else if (var22_19 && (var27_24 = (Option)var23_20.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var27_24).value();
                    if (BoxesRunTime.unboxToBoolean($anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$appendTransactionToLog$14(kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 ), ()Z)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        $anonfun$appendTransactionToLog$13_x$1 = newMetadata.txnTimeoutMs();
                        $anonfun$appendTransactionToLog$13_x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                        $anonfun$appendTransactionToLog$13_x$6 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(kafka.coordinator.transaction.TransactionStateManager org.apache.kafka.common.TopicPartition java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int scala.Function1 scala.Function1 scala.collection.Map ), (Lscala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicPartition)topicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback);
                        $anonfun$appendTransactionToLog$13_x$8 = this.replicaManager.appendRecords$default$7();
                        $anonfun$appendTransactionToLog$13_x$9 = this.replicaManager.appendRecords$default$8();
                        $anonfun$appendTransactionToLog$13_x$10 = this.replicaManager.appendRecords$default$10();
                        $anonfun$appendTransactionToLog$13_x$11 = this.replicaManager.appendRecords$default$11();
                        this.replicaManager.appendRecords($anonfun$appendTransactionToLog$13_x$1, $anonfun$appendTransactionToLog$13_x$2, true, AppendOrigin.COORDINATOR, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)$anonfun$appendTransactionToLog$13_x$6, $anonfun$appendTransactionToLog$13_x$8, $anonfun$appendTransactionToLog$13_x$9, requestLocal, $anonfun$appendTransactionToLog$13_x$10, $anonfun$appendTransactionToLog$13_x$11);
                        this.trace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var24_21);
                }
            }
            var23_20 = null;
            var24_21 = null;
            var25_22 = null;
            var26_23 = null;
            var27_24 = null;
            var28_25 = null;
            var32_28 = null;
            var33_29 = null;
            var34_30 = null;
            var35_31 = null;
            var36_32 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$9));
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
            return;
        }
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                return false;
            }
            TransactionState transactionState = txnMetadata.state();
            if (Ongoing$.MODULE$.equals(transactionState)) {
                return txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1;
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (IterableOnce)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        String txnId = (String)x0$3._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                        return new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            int maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, maxBatchSize)), (Compression)TransactionLog$.MODULE$.EnforcedCompression(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)maxBatchSize);
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                    expired.clear();
                    recordsBuilder.elem = null;
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                expired.clear();
                recordsBuilder.elem = null;
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> "Transaction expiration for partition " + transactionPartition$1 + " failed because the log config was not available, which likely means the partition is not online or is no longer local.");
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, int partitionId, TxnMetadataCacheEntry partitionCacheEntry) {
        TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
        $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        $this.transactionMetadataCache().foreachEntry((Function2 & Serializable)(partitionId, partitionCacheEntry) -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, BoxesRunTime.unboxToInt((Object)partitionId), partitionCacheEntry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to remove expired transactionalId: " + transactionalId + " from cache. Tombstone append error code: " + response$1.error + ", pendingState: " + txnMetadata.pendingState() + ", producerEpoch: " + txnMetadata.producerEpoch() + ", expected producerEpoch: " + idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch() + ", coordinatorEpoch: " + txnMetadataCacheEntry.coordinatorEpoch() + ", expected coordinatorEpoch: " + idCoordinatorEpochAndMetadata.coordinatorEpoch());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        Lock inReadLock_inLock_lock = $this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        responses.foreachEntry((Function2 & Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$7(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        long x$1 = $this.config.requestTimeoutMs();
        short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionPartition$2), (Object)tombstoneRecords$1)}));
        Function1 & Serializable x$6 = (Function1 & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$7 = RequestLocal.noCaching();
        Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordValidationStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
        ActionQueue x$10 = $this.replicaManager.appendRecords$default$10();
        Map<TopicPartition, VerificationGuard> x$11 = $this.replicaManager.appendRecords$default$11();
        $this.replicaManager.appendRecords(x$1, x$2, true, AppendOrigin.COORDINATOR, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$7, x$10, x$11);
    }

    private static final boolean shouldInclude$1(TransactionMetadata txnMetadata, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, long filterDurationMs$1, long now$2) {
        TransactionState transactionState = txnMetadata.state();
        Dead$ dead$ = Dead$.MODULE$;
        if (transactionState != null && transactionState.equals(dead$)) {
            return false;
        }
        if (filterProducerIds$1.nonEmpty() && !filterProducerIds$1.contains((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()))) {
            return false;
        }
        if (filterStateNames$1.nonEmpty() && !filterStates$1.contains((Object)txnMetadata.state())) {
            return false;
        }
        return filterDurationMs$1 < 0L || now$2 - txnMetadata.txnStartTimestamp() > filterDurationMs$1;
    }

    public static final /* synthetic */ void $anonfun$listTransactionStates$3(ArrayList states$1, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, long filterDurationMs$1, long now$2, int x$4, TxnMetadataCacheEntry cache) {
        cache.metadataPerTransactionalId().values().foreach((Function1 & Serializable)txnMetadata -> txnMetadata.inLock((Function0 & Serializable)() -> {
            if (TransactionStateManager.shouldInclude$1(txnMetadata, filterProducerIds$1, filterStateNames$1, filterStates$1, filterDurationMs$1, now$2)) {
                return BoxesRunTime.boxToBoolean((boolean)states$1.add(new ListTransactionsResponseData.TransactionState().setTransactionalId(txnMetadata.transactionalId()).setProducerId(txnMetadata.producerId()).setTransactionState(txnMetadata.state().name())));
            }
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ ListTransactionsResponseData $anonfun$listTransactionStates$1(TransactionStateManager $this, scala.collection.immutable.Set filterStateNames$1, scala.collection.immutable.Set filterProducerIds$1, long filterDurationMs$1) {
        ListTransactionsResponseData response = new ListTransactionsResponseData();
        if ($this.loadingPartitions().nonEmpty()) {
            return response.setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        }
        Set filterStates = (Set)Set$.MODULE$.empty();
        filterStateNames$1.foreach((Function1 & Serializable)stateName -> {
            Option<TransactionState> option = TransactionState$.MODULE$.fromName((String)stateName);
            if (option instanceof Some) {
                TransactionState state = (TransactionState)((Some)option).value();
                return filterStates.$plus$eq((Object)state);
            }
            if (None$.MODULE$.equals(option)) {
                return BoxesRunTime.boxToBoolean((boolean)response.unknownStateFilters().add(stateName));
            }
            throw new MatchError(option);
        });
        long now = $this.time.milliseconds();
        ArrayList states = new ArrayList();
        $this.transactionMetadataCache().foreachEntry((Function2 & Serializable)(x$4, cache) -> {
            TransactionStateManager.$anonfun$listTransactionStates$3(states, filterProducerIds$1, filterStateNames$1, filterStates, filterDurationMs$1, now, BoxesRunTime.unboxToInt((Object)x$4), cache);
            return BoxedUnit.UNIT;
        });
        return response.setErrorCode(Errors.NONE.code()).setTransactionStates(states);
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$5) {
        return x$5.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$5)))) {
            return new Left((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3)).orElse((Function0 & Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId$3, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable)() -> createdTxnMetadata)));
            return new Right((Object)txnMetadata.map((Function1 & Serializable)x$6 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$6)));
        }
        if (None$.MODULE$.equals(option)) {
            return new Left((Object)Errors.NOT_COORDINATOR);
        }
        throw new MatchError((Object)option);
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$7(TransactionStateManager $this, int partitionId$2, Function4 sendTxnMarkers$1, TransactionalIdCoordinatorEpochAndTransitMetadata txnTransitMetadata) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> "Sending txn markers for " + txnTransitMetadata + " after loading partition " + partitionId$2);
        sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, int partitionId$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    return txnMetadata.inLock((Function0 & Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                        }
                        if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                        }
                        return BoxedUnit.UNIT;
                    });
                }
                throw new MatchError(null);
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$7(this, partitionId$2, sendTxnMarkers$1, txnTransitMetadata);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, int partitionId$2, Function4 sendTxnMarkers$1) {
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Loading transaction metadata from " + topicPartition$3 + " at epoch " + coordinatorEpoch$3);
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Finished loading " + loadedTransactions.size() + " transaction metadata from " + topicPartition$3 + " in " + totalLoadingTimeMs + " milliseconds, of which " + schedulerTimeMs + " milliseconds was spent in the scheduler.");
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        String transactionalId = (String)x0$1._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                        return txnMetadata.inLock((Function0 & Serializable)() -> {
                            TransactionState transactionState = txnMetadata.state();
                            if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            return BoxedUnit.UNIT;
                        });
                    }
                    throw new MatchError(null);
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$7(this, partitionId$2, sendTxnMarkers$1, txnTransitMetadata);
                    return BoxedUnit.UNIT;
                });
            }
            Object var16_12 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var14_11 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> "Completed loading transaction metadata from " + topicPartition$3 + " for coordinator epoch " + coordinatorEpoch$3);
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$3, TransactionPartitionAndLeaderEpoch x$7) {
        return x$7.txnPartitionId() == partitionId$3;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$3, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((IterableOnce)$this.loadingPartitions().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$3, x$7))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3)).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Unloaded transaction metadata " + txnMetadataCacheEntry + " for " + topicPartition$4 + " following local partition deletion");
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, int partitionId$4, int coordinatorEpoch$4, TopicPartition topicPartition$5) {
        $this.removeLoadingPartitionWithEpoch(partitionId$4, coordinatorEpoch$4);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$4));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Unloaded transaction metadata " + txnMetadataCacheEntry + " for " + topicPartition$5 + " on become-follower transition");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "No cached transaction metadata found for " + topicPartition$5 + " during become-follower transition");
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$removeLoadingPartitionWithEpoch$1(int partitionId$5, TransactionPartitionAndLeaderEpoch x$8) {
        return x$8.txnPartitionId() == partitionId$5;
    }

    public static final /* synthetic */ void $anonfun$removeLoadingPartitionWithEpoch$2(TransactionStateManager $this, int coordinatorEpoch$5, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch) {
        if (partitionAndLeaderEpoch.coordinatorEpoch() < coordinatorEpoch$5) {
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch);
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Cancelling load of currently loading partition " + partitionAndLeaderEpoch);
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return "Appending " + transactionalId$5 + "'s new metadata " + newMetadata$1 + " failed due to " + status$1.error.exceptionName();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return "Accessing the cached transaction metadata for " + transactionalId$5 + " returns " + err$1 + " error; aborting transition to the new metadata and setting the error in the callback";
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$6) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "The cached coordinator epoch for " + transactionalId$5 + " has changed to " + epochAndMetadata$1.coordinatorEpoch() + " after appended its new metadata " + newMetadata$1 + " to the transaction log (txn topic partition " + $this.partitionFor(transactionalId$5) + ") while it was " + coordinatorEpoch$6 + " before appending; aborting transition to the new metadata and returning " + Errors.NOT_COORDINATOR + " in the callback");
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable)() -> "Updating " + transactionalId$5 + "'s transaction state to " + newMetadata$1 + " with coordinator epoch " + coordinatorEpoch$6 + " for " + transactionalId$5 + " succeeded");
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$6) {
        return "The cached coordinator metadata does not exist in the cache anymore for " + transactionalId$5 + " after appended its new metadata " + newMetadata$1 + " to the transaction log (txn topic partition " + $this.partitionFor(transactionalId$5) + ") while it was " + coordinatorEpoch$6 + " before appending; aborting transition to the new metadata and returning " + Errors.NOT_COORDINATOR + " in the callback";
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$6, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$6) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> "TransactionalId " + metadata$2.transactionalId() + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", not resetting pending state " + metadata$2.pendingState() + " but just returning the error in the callback to let the caller retry");
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable)() -> "TransactionalId " + metadata$2.transactionalId() + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", resetting pending state from " + metadata$2.pendingState() + ", aborting state transition and returning " + (Errors)responseError$1.elem + " in the callback");
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> "TransactionalId " + metadata$2.transactionalId() + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", aborting state transition and returning the error in the callback since the coordinator epoch has changed from " + epochAndTxnMetadata$1.coordinatorEpoch() + " to " + coordinatorEpoch$6);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return "TransactionalId " + transactionalId$5 + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", aborting state transition and returning the error in the callback since metadata is not available in the cache anymore";
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return "TransactionalId " + transactionalId$5 + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", aborting state transition and returning the error in the callback since retrieving metadata returned " + error$1;
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$6, Function1 retryOnError$1, Function1 responseCallback$1) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var11_10 = status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var12_12 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_12) == false : var12_12 != null) break block9;
                            var13_13 = false;
                            var14_14 = null;
                            var15_15 = this.getTransactionState(transactionalId$5);
                            if (!(var15_15 instanceof Left)) break block10;
                            err = (Errors)((Left)var15_15).value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block11;
                        }
                        if (!(var15_15 instanceof Right)) break block12;
                        var13_13 = true;
                        var14_14 = (Right)var15_15;
                        var17_17 = (Option)var14_14.value();
                        if (!(var17_17 instanceof Some)) break block12;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_17).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$6, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block11;
                    }
                    if (!var13_13 || !None$.MODULE$.equals(var20_20 = (Option)var14_14.value())) break block13;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$6));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_15);
            }
            var21_21 = false;
            var22_22 = null;
            var23_23 = this.getTransactionState(transactionalId$5);
            if (!(var23_23 instanceof Right)) ** GOTO lbl-1000
            var21_21 = true;
            var22_22 = (Right)var23_23;
            var24_24 = (Option)var22_22.value();
            if (var24_24 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_24).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$6, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_21 && None$.MODULE$.equals(var27_27 = (Option)var22_22.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var23_23 instanceof Left) {
                error = (Errors)((Left)var23_23).value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var23_23);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$6, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, RequestLocal requestLocal$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$6) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                long x$1 = newMetadata$1.txnTimeoutMs();
                short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                Function1 & Serializable x$6 = (Function1 & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$6, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                };
                Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
                Function1<Map<TopicPartition, RecordValidationStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
                ActionQueue x$10 = $this.replicaManager.appendRecords$default$10();
                Map<TopicPartition, VerificationGuard> x$11 = $this.replicaManager.appendRecords$default$11();
                $this.replicaManager.appendRecords(x$1, x$2, true, AppendOrigin.COORDINATOR, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, requestLocal$1, x$10, x$11);
                $this.trace((Function0<String>)(Function0 & Serializable)() -> "Appending new metadata " + newMetadata$1 + " for transaction id " + transactionalId$5 + " with coordinator epoch " + coordinatorEpoch$6 + " to the local transaction log");
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$9) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, MetadataCache metadataCache, TransactionConfig config, Time time, Metrics metrics) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        void sensor_name;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.metadataCache = metadataCache;
        this.config = config;
        this.time = time;
        this.logIdent_$eq("[Transaction State Manager " + brokerId + "]: ");
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        String string = "TransactionsPartitionLoadTime";
        if (metrics == null) {
            throw null;
        }
        Sensor.RecordingLevel sensor_recordingLevel = Sensor.RecordingLevel.INFO;
        Object var13_9 = null;
        string = null;
        this.partitionLoadSensor = metrics.sensor((String)sensor_name, null, sensor_recordingLevel, (Sensor[])null);
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", "transaction-coordinator-metrics", "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", "transaction-coordinator-metrics", "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }
}

