/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.trogdor.common.StringExpander;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.RecordProcessor;
import org.apache.kafka.trogdor.workload.ShareConsumeBenchWorker;

public final class ShareConsumeBenchSpec
extends TaskSpec {
    private static final String VALID_EXPANDED_TOPIC_NAME_PATTERN = "^[^:]+$";
    private static final String DEFAULT_SHARE_GROUP_NAME = "share";
    private final String consumerNode;
    private final String bootstrapServers;
    private final int targetMessagesPerSec;
    private final long maxMessages;
    private final Map<String, String> consumerConf;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final List<String> activeTopics;
    private final String shareGroup;
    private final int threadsPerWorker;
    private final Optional<RecordProcessor> recordProcessor;

    @JsonCreator
    public ShareConsumeBenchSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="consumerNode") String consumerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetMessagesPerSec") int targetMessagesPerSec, @JsonProperty(value="maxMessages") long maxMessages, @JsonProperty(value="consumerGroup") String shareGroup, @JsonProperty(value="consumerConf") Map<String, String> consumerConf, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="threadsPerWorker") Integer threadsPerWorker, @JsonProperty(value="recordProcessor") Optional<RecordProcessor> recordProcessor, @JsonProperty(value="activeTopics") List<String> activeTopics) {
        super(startMs, durationMs);
        this.consumerNode = consumerNode == null ? "" : consumerNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.targetMessagesPerSec = targetMessagesPerSec;
        this.maxMessages = maxMessages;
        this.consumerConf = ShareConsumeBenchSpec.configOrEmptyMap(consumerConf);
        this.commonClientConf = ShareConsumeBenchSpec.configOrEmptyMap(commonClientConf);
        this.adminClientConf = ShareConsumeBenchSpec.configOrEmptyMap(adminClientConf);
        this.activeTopics = activeTopics == null ? new ArrayList() : activeTopics;
        this.shareGroup = shareGroup == null ? DEFAULT_SHARE_GROUP_NAME : shareGroup;
        this.threadsPerWorker = threadsPerWorker == null ? 1 : threadsPerWorker;
        this.recordProcessor = recordProcessor;
    }

    @JsonProperty
    public String consumerNode() {
        return this.consumerNode;
    }

    @JsonProperty
    public String shareGroup() {
        return this.shareGroup;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetMessagesPerSec() {
        return this.targetMessagesPerSec;
    }

    @JsonProperty
    public long maxMessages() {
        return this.maxMessages;
    }

    @JsonProperty
    public int threadsPerWorker() {
        return this.threadsPerWorker;
    }

    @JsonProperty
    public Optional<RecordProcessor> recordProcessor() {
        return this.recordProcessor;
    }

    @JsonProperty
    public Map<String, String> consumerConf() {
        return this.consumerConf;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public List<String> activeTopics() {
        return this.activeTopics;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.consumerNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ShareConsumeBenchWorker(id, this);
    }

    Set<String> expandTopicNames() {
        HashSet<String> expandedTopics = new HashSet<String>();
        for (String rawTopicName : this.activeTopics) {
            Set<String> expandedNames = this.expandTopicName(rawTopicName);
            if (!expandedNames.iterator().next().matches(VALID_EXPANDED_TOPIC_NAME_PATTERN)) {
                throw new IllegalArgumentException(String.format("Expanded topic name %s is invalid", expandedNames));
            }
            expandedTopics.addAll(expandedNames);
        }
        return expandedTopics;
    }

    private Set<String> expandTopicName(String topicName) {
        HashSet<String> expandedNames = StringExpander.expand(topicName);
        if (expandedNames.size() == 1) {
            return expandedNames;
        }
        HashSet<String> newNames = new HashSet<String>();
        for (String name : expandedNames) {
            newNames.addAll(this.expandTopicName(name));
        }
        return newNames;
    }
}

