/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.assignor.AssignorHelpers;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.server.common.TopicIdPartition;

public class UniformHomogeneousAssignmentBuilder {
    private final GroupSpec groupSpec;
    private final SubscribedTopicDescriber subscribedTopicDescriber;
    private final Set<Uuid> subscribedTopicIds;
    private final List<MemberWithRemainingQuota> unfilledMembers;
    private final List<TopicIdPartition> unassignedPartitions;
    private final Map<String, MemberAssignment> targetAssignment;
    private int minimumMemberQuota;
    private int remainingMembersToGetAnExtraPartition;

    UniformHomogeneousAssignmentBuilder(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        this.groupSpec = groupSpec;
        this.subscribedTopicDescriber = subscribedTopicDescriber;
        this.subscribedTopicIds = new HashSet<Uuid>(groupSpec.memberSubscription((String)groupSpec.memberIds().iterator().next()).subscribedTopicIds());
        this.unfilledMembers = new ArrayList<MemberWithRemainingQuota>();
        this.unassignedPartitions = new ArrayList<TopicIdPartition>();
        this.targetAssignment = new HashMap<String, MemberAssignment>();
    }

    public GroupAssignment build() throws PartitionAssignorException {
        if (this.subscribedTopicIds.isEmpty()) {
            return new GroupAssignment(Collections.emptyMap());
        }
        int totalPartitionsCount = 0;
        for (Uuid topicId : this.subscribedTopicIds) {
            int partitionCount = this.subscribedTopicDescriber.numPartitions(topicId);
            if (partitionCount == -1) {
                throw new PartitionAssignorException("Members are subscribed to topic " + String.valueOf(topicId) + " which doesn't exist in the topic metadata.");
            }
            for (int i = 0; i < partitionCount; ++i) {
                if (this.groupSpec.isPartitionAssigned(topicId, i)) continue;
                this.unassignedPartitions.add(new TopicIdPartition(topicId, i));
            }
            totalPartitionsCount += partitionCount;
        }
        int numberOfMembers = this.groupSpec.memberIds().size();
        this.minimumMemberQuota = totalPartitionsCount / numberOfMembers;
        this.remainingMembersToGetAnExtraPartition = totalPartitionsCount % numberOfMembers;
        this.maybeRevokePartitions();
        this.assignRemainingPartitions();
        return new GroupAssignment(this.targetAssignment);
    }

    private void maybeRevokePartitions() {
        for (String memberId : this.groupSpec.memberIds()) {
            Map oldAssignment = this.groupSpec.memberAssignment(memberId).partitions();
            Map<Uuid, Set<Integer>> newAssignment = null;
            if (!AssignorHelpers.isImmutableMap(oldAssignment)) {
                throw new IllegalStateException("The assignor expect an immutable map.");
            }
            int quota = this.minimumMemberQuota;
            if (this.remainingMembersToGetAnExtraPartition > 0) {
                ++quota;
                --this.remainingMembersToGetAnExtraPartition;
            }
            for (Map.Entry topicPartitions : oldAssignment.entrySet()) {
                Uuid topicId = (Uuid)topicPartitions.getKey();
                Set partitions = (Set)topicPartitions.getValue();
                if (this.subscribedTopicIds.contains(topicId)) {
                    if (partitions.size() <= quota) {
                        quota -= partitions.size();
                        continue;
                    }
                    for (Integer partition : partitions) {
                        if (quota > 0) {
                            --quota;
                            continue;
                        }
                        if (newAssignment == null) {
                            newAssignment = AssignorHelpers.deepCopyAssignment(oldAssignment);
                        }
                        Set<Integer> parts = newAssignment.get(topicId);
                        parts.remove(partition);
                        if (parts.isEmpty()) {
                            newAssignment.remove(topicId);
                        }
                        this.unassignedPartitions.add(new TopicIdPartition(topicId, partition.intValue()));
                    }
                    continue;
                }
                if (newAssignment == null) {
                    newAssignment = AssignorHelpers.deepCopyAssignment(oldAssignment);
                }
                newAssignment.remove(topicId);
            }
            if (quota > 0) {
                this.unfilledMembers.add(new MemberWithRemainingQuota(memberId, quota));
            }
            if (newAssignment == null) {
                this.targetAssignment.put(memberId, new MemberAssignmentImpl(oldAssignment));
                continue;
            }
            this.targetAssignment.put(memberId, new MemberAssignmentImpl(newAssignment));
        }
    }

    private void assignRemainingPartitions() {
        int unassignedPartitionIndex = 0;
        for (MemberWithRemainingQuota unfilledMember : this.unfilledMembers) {
            String memberId = unfilledMember.memberId;
            int remainingQuota = unfilledMember.remainingQuota;
            Map<Uuid, Set<Integer>> newAssignment = this.targetAssignment.get(memberId).partitions();
            if (AssignorHelpers.isImmutableMap(newAssignment)) {
                newAssignment = AssignorHelpers.deepCopyAssignment(newAssignment);
                this.targetAssignment.put(memberId, new MemberAssignmentImpl(newAssignment));
            }
            for (int i = 0; i < remainingQuota && unassignedPartitionIndex < this.unassignedPartitions.size(); ++unassignedPartitionIndex, ++i) {
                TopicIdPartition unassignedTopicIdPartition = this.unassignedPartitions.get(unassignedPartitionIndex);
                newAssignment.computeIfAbsent(unassignedTopicIdPartition.topicId(), __ -> new HashSet()).add(unassignedTopicIdPartition.partitionId());
            }
        }
        if (unassignedPartitionIndex < this.unassignedPartitions.size()) {
            throw new PartitionAssignorException("Partitions were left unassigned");
        }
    }

    private static class MemberWithRemainingQuota {
        final String memberId;
        final int remainingQuota;

        MemberWithRemainingQuota(String memberId, int remainingQuota) {
            this.memberId = memberId;
            this.remainingQuota = remainingQuota;
        }
    }
}

