/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;

public class PluginSource {
    private final Path location;
    private final Type type;
    private final ClassLoader loader;
    private final URL[] urls;

    public PluginSource(Path location, Type type, ClassLoader loader, URL[] urls) {
        this.location = location;
        this.type = type;
        this.loader = loader;
        this.urls = urls;
    }

    public Path location() {
        return this.location;
    }

    public Type type() {
        return this.type;
    }

    public ClassLoader loader() {
        return this.loader;
    }

    public URL[] urls() {
        return this.urls;
    }

    public boolean isolated() {
        return this.location != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginSource that = (PluginSource)o;
        return Objects.equals(this.location, that.location) && this.loader.equals(that.loader) && Arrays.equals(this.urls, that.urls);
    }

    public int hashCode() {
        int result = Objects.hash(this.location, this.loader);
        result = 31 * result + Arrays.hashCode(this.urls);
        return result;
    }

    public String toString() {
        return this.location == null ? "classpath" : this.location.toString();
    }

    public static enum Type {
        CLASSPATH,
        MULTI_JAR,
        SINGLE_JAR,
        CLASS_HIERARCHY;

    }
}

