/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;

public class PluginScanResult {
    private final SortedSet<PluginDesc<SinkConnector>> sinkConnectors;
    private final SortedSet<PluginDesc<SourceConnector>> sourceConnectors;
    private final SortedSet<PluginDesc<Converter>> converters;
    private final SortedSet<PluginDesc<HeaderConverter>> headerConverters;
    private final SortedSet<PluginDesc<Transformation<?>>> transformations;
    private final SortedSet<PluginDesc<Predicate<?>>> predicates;
    private final SortedSet<PluginDesc<ConfigProvider>> configProviders;
    private final SortedSet<PluginDesc<ConnectRestExtension>> restExtensions;
    private final SortedSet<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies;
    private final List<SortedSet<? extends PluginDesc<?>>> allPlugins;

    public PluginScanResult(SortedSet<PluginDesc<SinkConnector>> sinkConnectors, SortedSet<PluginDesc<SourceConnector>> sourceConnectors, SortedSet<PluginDesc<Converter>> converters, SortedSet<PluginDesc<HeaderConverter>> headerConverters, SortedSet<PluginDesc<Transformation<?>>> transformations, SortedSet<PluginDesc<Predicate<?>>> predicates, SortedSet<PluginDesc<ConfigProvider>> configProviders, SortedSet<PluginDesc<ConnectRestExtension>> restExtensions, SortedSet<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies) {
        this.sinkConnectors = sinkConnectors;
        this.sourceConnectors = sourceConnectors;
        this.converters = converters;
        this.headerConverters = headerConverters;
        this.transformations = transformations;
        this.predicates = predicates;
        this.configProviders = configProviders;
        this.restExtensions = restExtensions;
        this.connectorClientConfigPolicies = connectorClientConfigPolicies;
        this.allPlugins = Arrays.asList(sinkConnectors, sourceConnectors, converters, headerConverters, transformations, predicates, configProviders, restExtensions, connectorClientConfigPolicies);
    }

    public PluginScanResult(List<PluginScanResult> results) {
        this(PluginScanResult.merge(results, PluginScanResult::sinkConnectors), PluginScanResult.merge(results, PluginScanResult::sourceConnectors), PluginScanResult.merge(results, PluginScanResult::converters), PluginScanResult.merge(results, PluginScanResult::headerConverters), PluginScanResult.merge(results, PluginScanResult::transformations), PluginScanResult.merge(results, PluginScanResult::predicates), PluginScanResult.merge(results, PluginScanResult::configProviders), PluginScanResult.merge(results, PluginScanResult::restExtensions), PluginScanResult.merge(results, PluginScanResult::connectorClientConfigPolicies));
    }

    private static <R extends Comparable<?>> SortedSet<R> merge(List<PluginScanResult> results, Function<PluginScanResult, SortedSet<R>> accessor) {
        TreeSet merged = new TreeSet();
        for (PluginScanResult element : results) {
            merged.addAll(accessor.apply(element));
        }
        return merged;
    }

    public SortedSet<PluginDesc<SinkConnector>> sinkConnectors() {
        return this.sinkConnectors;
    }

    public SortedSet<PluginDesc<SourceConnector>> sourceConnectors() {
        return this.sourceConnectors;
    }

    public SortedSet<PluginDesc<Converter>> converters() {
        return this.converters;
    }

    public SortedSet<PluginDesc<HeaderConverter>> headerConverters() {
        return this.headerConverters;
    }

    public SortedSet<PluginDesc<Transformation<?>>> transformations() {
        return this.transformations;
    }

    public SortedSet<PluginDesc<Predicate<?>>> predicates() {
        return this.predicates;
    }

    public SortedSet<PluginDesc<ConfigProvider>> configProviders() {
        return this.configProviders;
    }

    public SortedSet<PluginDesc<ConnectRestExtension>> restExtensions() {
        return this.restExtensions;
    }

    public SortedSet<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies() {
        return this.connectorClientConfigPolicies;
    }

    public void forEach(Consumer<PluginDesc<?>> consumer) {
        this.allPlugins.forEach((? super T plugins) -> plugins.forEach(consumer));
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        for (SortedSet<PluginDesc<?>> plugins : this.allPlugins) {
            isEmpty = isEmpty && plugins.isEmpty();
        }
        return isEmpty;
    }
}

