/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Objects;
import java.util.Optional;

public final class VersionedRecord<V> {
    private final V value;
    private final long timestamp;
    private final Optional<Long> validTo;

    public VersionedRecord(V value, long timestamp) {
        this.value = Objects.requireNonNull(value, "value cannot be null.");
        this.timestamp = timestamp;
        this.validTo = Optional.empty();
    }

    public VersionedRecord(V value, long timestamp, long validTo) {
        this.value = Objects.requireNonNull(value);
        this.timestamp = timestamp;
        this.validTo = Optional.of(validTo);
    }

    public V value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Optional<Long> validTo() {
        return this.validTo;
    }

    public String toString() {
        return "<" + String.valueOf(this.value) + "," + this.timestamp + "," + String.valueOf(this.validTo) + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedRecord that = (VersionedRecord)o;
        return this.timestamp == that.timestamp && this.validTo == that.validTo && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.timestamp, this.validTo);
    }
}

