/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StateUpdater;
import org.apache.kafka.streams.processor.internals.Task;

public class TaskAndAction {
    private final Task task;
    private final TaskId taskId;
    private final Action action;
    private final CompletableFuture<StateUpdater.RemovedTaskResult> futureForRemove;

    private TaskAndAction(Task task, TaskId taskId, Action action, CompletableFuture<StateUpdater.RemovedTaskResult> futureForRemove) {
        this.task = task;
        this.taskId = taskId;
        this.action = action;
        this.futureForRemove = futureForRemove;
    }

    public static TaskAndAction createAddTask(Task task) {
        Objects.requireNonNull(task, "Task to add is null!");
        return new TaskAndAction(task, null, Action.ADD, null);
    }

    public static TaskAndAction createRemoveTask(TaskId taskId, CompletableFuture<StateUpdater.RemovedTaskResult> future) {
        Objects.requireNonNull(taskId, "Task ID of task to remove is null!");
        Objects.requireNonNull(future, "Future for task to remove is null!");
        return new TaskAndAction(null, taskId, Action.REMOVE, future);
    }

    public static TaskAndAction createRemoveTask(TaskId taskId) {
        Objects.requireNonNull(taskId, "Task ID of task to remove is null!");
        return new TaskAndAction(null, taskId, Action.REMOVE, null);
    }

    public Task task() {
        if (this.action != Action.ADD) {
            throw new IllegalStateException("Action type " + String.valueOf((Object)this.action) + " cannot have a task!");
        }
        return this.task;
    }

    public TaskId taskId() {
        if (this.action != Action.REMOVE) {
            throw new IllegalStateException("Action type " + String.valueOf((Object)this.action) + " cannot have a task ID!");
        }
        return this.taskId;
    }

    public CompletableFuture<StateUpdater.RemovedTaskResult> futureForRemove() {
        if (this.action != Action.REMOVE) {
            throw new IllegalStateException("Action type " + String.valueOf((Object)this.action) + " cannot have a future with a single result!");
        }
        return this.futureForRemove;
    }

    public Action action() {
        return this.action;
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

