/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.NamedOperation;

public class Joined<K, VLeft, VRight>
implements NamedOperation<Joined<K, VLeft, VRight>> {
    protected final Serde<K> keySerde;
    protected final Serde<VLeft> leftValueSerde;
    protected final Serde<VRight> rightValueSerde;
    protected final String name;
    protected final Duration gracePeriod;

    private Joined(Serde<K> keySerde, Serde<VLeft> leftValueSerde, Serde<VRight> rightValueSerde, String name, Duration gracePeriod) {
        this.keySerde = keySerde;
        this.leftValueSerde = leftValueSerde;
        this.rightValueSerde = rightValueSerde;
        this.name = name;
        this.gracePeriod = gracePeriod;
    }

    protected Joined(Joined<K, VLeft, VRight> joined) {
        this(joined.keySerde, joined.leftValueSerde, joined.rightValueSerde, joined.name, joined.gracePeriod);
    }

    public static <K, VLeft, VRight> Joined<K, VLeft, VRight> with(Serde<K> keySerde, Serde<VLeft> leftValueSerde, Serde<VRight> rightValueSerde) {
        return new Joined<K, VLeft, VRight>(keySerde, leftValueSerde, rightValueSerde, null, null);
    }

    public static <K, VLeft, VRight> Joined<K, VLeft, VRight> with(Serde<K> keySerde, Serde<VLeft> leftValueSerde, Serde<VRight> rightValueSerde, String name) {
        return new Joined<K, VLeft, VRight>(keySerde, leftValueSerde, rightValueSerde, name, null);
    }

    public static <K, VLeft, VRight> Joined<K, VLeft, VRight> with(Serde<K> keySerde, Serde<VLeft> leftValueSerde, Serde<VRight> rightValueSerde, String name, Duration gracePeriod) {
        return new Joined<K, VLeft, VRight>(keySerde, leftValueSerde, rightValueSerde, name, gracePeriod);
    }

    public static <K, VLeft, VRight> Joined<K, VLeft, VRight> keySerde(Serde<K> keySerde) {
        return new Joined<K, VLeft, VRight>(keySerde, null, null, null, null);
    }

    public static <K, VLeft, VRight> Joined<K, VLeft, VRight> valueSerde(Serde<VLeft> leftValueSerde) {
        return new Joined<K, VLeft, VRight>(null, leftValueSerde, null, null, null);
    }

    public static <K, VLeft, VRight> Joined<K, VLeft, VRight> otherValueSerde(Serde<VRight> rightValueSerde) {
        return new Joined<K, VLeft, VRight>(null, null, rightValueSerde, null, null);
    }

    public static <K, VLeft, VRight> Joined<K, VLeft, VRight> as(String name) {
        return new Joined<K, VLeft, VRight>(null, null, null, name, null);
    }

    public Joined<K, VLeft, VRight> withKeySerde(Serde<K> keySerde) {
        return new Joined<K, VLeft, VRight>(keySerde, this.leftValueSerde, this.rightValueSerde, this.name, this.gracePeriod);
    }

    public Joined<K, VLeft, VRight> withValueSerde(Serde<VLeft> leftValueSerde) {
        return new Joined<K, VLeft, VRight>(this.keySerde, leftValueSerde, this.rightValueSerde, this.name, this.gracePeriod);
    }

    public Joined<K, VLeft, VRight> withOtherValueSerde(Serde<VRight> rightValueSerde) {
        return new Joined<K, VLeft, VRight>(this.keySerde, this.leftValueSerde, rightValueSerde, this.name, this.gracePeriod);
    }

    @Override
    public Joined<K, VLeft, VRight> withName(String name) {
        return new Joined<K, VLeft, VRight>(this.keySerde, this.leftValueSerde, this.rightValueSerde, name, this.gracePeriod);
    }

    public Joined<K, VLeft, VRight> withGracePeriod(Duration gracePeriod) {
        return new Joined<K, VLeft, VRight>(this.keySerde, this.leftValueSerde, this.rightValueSerde, this.name, gracePeriod);
    }

    @Deprecated
    public Duration gracePeriod() {
        return this.gracePeriod;
    }

    @Deprecated
    public Serde<K> keySerde() {
        return this.keySerde;
    }

    @Deprecated
    public Serde<VLeft> valueSerde() {
        return this.leftValueSerde;
    }

    @Deprecated
    public Serde<VRight> otherValueSerde() {
        return this.rightValueSerde;
    }
}

