/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.group.share;

import java.util.stream.Collectors;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.server.group.share.GroupTopicPartitionData;
import org.apache.kafka.server.group.share.PartitionFactory;
import org.apache.kafka.server.group.share.PartitionStateBatchData;
import org.apache.kafka.server.group.share.PersisterParameters;
import org.apache.kafka.server.group.share.PersisterStateBatch;
import org.apache.kafka.server.group.share.TopicData;

public class WriteShareGroupStateParameters
implements PersisterParameters {
    private final GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData;

    private WriteShareGroupStateParameters(GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData) {
        this.groupTopicPartitionData = groupTopicPartitionData;
    }

    public GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData() {
        return this.groupTopicPartitionData;
    }

    public static WriteShareGroupStateParameters from(WriteShareGroupStateRequestData data) {
        return new Builder().setGroupTopicPartitionData(new GroupTopicPartitionData<PartitionStateBatchData>(data.groupId(), data.topics().stream().map(writeStateData -> new TopicData(writeStateData.topicId(), writeStateData.partitions().stream().map(partitionData -> PartitionFactory.newPartitionStateBatchData(partitionData.partition(), partitionData.stateEpoch(), partitionData.startOffset(), partitionData.leaderEpoch(), partitionData.stateBatches().stream().map(PersisterStateBatch::from).collect(Collectors.toList()))).collect(Collectors.toList()))).collect(Collectors.toList()))).build();
    }

    public String toString() {
        return "WriteShareGroupStateParameters(" + this.groupTopicPartitionData + ")";
    }

    public static class Builder {
        private GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData;

        public Builder setGroupTopicPartitionData(GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData) {
            this.groupTopicPartitionData = groupTopicPartitionData;
            return this;
        }

        public WriteShareGroupStateParameters build() {
            return new WriteShareGroupStateParameters(this.groupTopicPartitionData);
        }
    }
}

