/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.AbstractRocksDBTimeOrderedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.SegmentIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchInterface;

public class RocksDBTimeOrderedWindowSegmentedBytesStore
extends AbstractRocksDBTimeOrderedSegmentedBytesStore {
    RocksDBTimeOrderedWindowSegmentedBytesStore(String name, String metricsScope, long retention, long segmentInterval, boolean withIndex) {
        super(name, metricsScope, retention, segmentInterval, new PrefixedWindowKeySchemas.TimeFirstWindowKeySchema(), Optional.ofNullable(withIndex ? new PrefixedWindowKeySchemas.KeyFirstWindowKeySchema() : null));
    }

    public void put(Bytes key, long timestamp, int seqnum, byte[] value) {
        Bytes baseKey = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(key, timestamp, seqnum);
        this.put(baseKey, value);
    }

    byte[] fetch(Bytes key, long timestamp, int seqnum) {
        return this.get(PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(key, timestamp, seqnum));
    }

    @Override
    protected KeyValue<Bytes, byte[]> getIndexKeyValue(Bytes baseKey, byte[] baseValue) {
        byte[] key = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.extractStoreKeyBytes(baseKey.get());
        long timestamp = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.extractStoreTimestamp(baseKey.get());
        int seqnum = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.extractStoreSequence(baseKey.get());
        return KeyValue.pair(PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.toStoreKeyBinary(key, timestamp, seqnum), new byte[0]);
    }

    @Override
    Map<KeyValueSegment, WriteBatch> getWriteBatches(Collection<ConsumerRecord<byte[], byte[]>> records) {
        for (ConsumerRecord<byte[], byte[]> record : records) {
            long timestamp = WindowKeySchema.extractStoreTimestamp((byte[])record.key());
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
        }
        HashMap<KeyValueSegment, WriteBatch> writeBatchMap = new HashMap<KeyValueSegment, WriteBatch>();
        for (ConsumerRecord<byte[], byte[]> record : records) {
            long timestamp = WindowKeySchema.extractStoreTimestamp((byte[])record.key());
            long segmentId = this.segments.segmentId(timestamp);
            KeyValueSegment segment = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(segmentId, this.context, this.observedStreamTime);
            if (segment == null) continue;
            ChangelogRecordDeserializationHelper.applyChecksAndUpdatePosition(record, this.consistencyEnabled, this.position);
            try {
                WriteBatch batch = writeBatchMap.computeIfAbsent(segment, s -> new WriteBatch());
                if (this.hasIndex()) {
                    byte[] indexKey = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.fromNonPrefixWindowKey((byte[])record.key());
                    byte[] value = record.value() == null ? null : new byte[]{};
                    segment.addToBatch(new KeyValue<byte[], byte[]>(indexKey, value), (WriteBatchInterface)batch);
                }
                byte[] baseKey = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.fromNonPrefixWindowKey((byte[])record.key());
                segment.addToBatch(new KeyValue<byte[], Object>(baseKey, record.value()), (WriteBatchInterface)batch);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error restoring batch to store " + this.name(), e);
            }
        }
        return writeBatchMap;
    }

    @Override
    protected AbstractRocksDBTimeOrderedSegmentedBytesStore.IndexToBaseStoreIterator getIndexToBaseStoreIterator(SegmentIterator<KeyValueSegment> segmentIterator) {
        return new WindowKeySchemaIndexToBaseStoreIterator(segmentIterator);
    }

    private class WindowKeySchemaIndexToBaseStoreIterator
    extends AbstractRocksDBTimeOrderedSegmentedBytesStore.IndexToBaseStoreIterator {
        WindowKeySchemaIndexToBaseStoreIterator(KeyValueIterator<Bytes, byte[]> indexIterator) {
            super(RocksDBTimeOrderedWindowSegmentedBytesStore.this, indexIterator);
        }

        @Override
        protected Bytes getBaseKey(Bytes indexKey) {
            byte[] keyBytes = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.extractStoreKeyBytes(indexKey.get());
            long timestamp = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.extractStoreTimestamp(indexKey.get());
            int seqnum = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.extractStoreSequence(indexKey.get());
            return PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(keyBytes, timestamp, seqnum);
        }
    }
}

