/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.ArrayList;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedClassMeta;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfMetaProvider;
import org.apache.juneau.jena.RdfUtils;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.jena.annotation.RdfSchema;
import org.apache.juneau.xml.Namespace;

public class RdfClassMeta
extends ExtendedClassMeta {
    private final RdfCollectionFormat collectionFormat;
    private final Namespace namespace;

    public RdfClassMeta(ClassMeta<?> cm, RdfMetaProvider mp) {
        super(cm);
        ArrayList rdfs = CollectionUtils.list((Object[])new Rdf[0]);
        ArrayList schemas = CollectionUtils.list((Object[])new RdfSchema[0]);
        cm.forEachAnnotation(Rdf.class, x -> true, x -> rdfs.add(x));
        cm.forEachAnnotation(RdfSchema.class, x -> true, x -> schemas.add(x));
        this.collectionFormat = rdfs.stream().map(x -> x.collectionFormat()).filter(x -> x != RdfCollectionFormat.DEFAULT).findFirst().orElse(RdfCollectionFormat.DEFAULT);
        this.namespace = RdfUtils.findNamespace(rdfs, schemas);
    }

    protected RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }
}

