/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import org.apache.http.NameValuePair;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ThrowableUtils;

public class HttpPart
implements NameValuePair {
    private final String name;
    private final Object opart;
    private final String spart;
    private final HttpPartType partType;
    private final HttpPartSchema schema;
    private final HttpPartSerializerSession serializer;

    public HttpPart(String name, HttpPartType partType, HttpPartSchema schema, HttpPartSerializerSession serializer, Object part) {
        this.name = name;
        this.partType = partType;
        this.schema = schema;
        this.serializer = serializer;
        this.opart = part;
        this.spart = null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.spart != null) {
            return this.spart;
        }
        try {
            return this.serializer.serialize(this.partType, this.schema, this.opart);
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }
}

