/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.MethodInfo;

@BeanIgnore
public final class ParamInfo {
    private final ExecutableInfo eInfo;
    private final Parameter p;
    private final int index;
    private volatile Map<Class<?>, Optional<Annotation>> annotationMap;

    protected ParamInfo(ExecutableInfo eInfo, Parameter p, int index) {
        this.eInfo = eInfo;
        this.p = p;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public MethodInfo getMethod() {
        return this.eInfo.isConstructor() ? null : (MethodInfo)this.eInfo;
    }

    public ConstructorInfo getConstructor() {
        return this.eInfo.isConstructor() ? (ConstructorInfo)this.eInfo : null;
    }

    public ClassInfo getParameterType() {
        return this.eInfo.getParamType(this.index);
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.eInfo.getParameterAnnotations(this.index);
    }

    public <T extends Annotation> T getDeclaredAnnotation(Class<T> a) {
        if (a != null) {
            for (Annotation aa : this.eInfo.getParameterAnnotations(this.index)) {
                if (!a.isInstance(aa)) continue;
                return (T)aa;
            }
        }
        return null;
    }

    public <T extends Annotation> T getLastAnnotation(Class<T> a) {
        Optional<Annotation> o = this.annotationMap().get(a);
        if (o == null) {
            o = Optional.ofNullable(this.findAnnotation(a));
            this.annotationMap().put(a, o);
        }
        return (T)(o.isPresent() ? o.get() : null);
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getLastAnnotation(a) != null;
    }

    private <T extends Annotation> T findAnnotation(Class<T> a) {
        if (this.eInfo.isConstructor()) {
            for (Annotation a2 : this.eInfo.getParameterAnnotations(this.index)) {
                if (!a.isInstance(a2)) continue;
                return (T)a2;
            }
            return this.eInfo.getParamType(this.index).resolved().getLastAnnotation(a);
        }
        MethodInfo mi = (MethodInfo)this.eInfo;
        for (Method m2 : mi.getMatching()) {
            for (Annotation a2 : m2.getParameterAnnotations()[this.index]) {
                if (!a.isInstance(a2)) continue;
                return (T)a2;
            }
        }
        return this.eInfo.getParamType(this.index).resolved().getLastAnnotation(a);
    }

    public <T extends Annotation> List<T> getAnnotations(Class<T> a) {
        return this.appendAnnotations(new ArrayList(), a, true);
    }

    private <T extends Annotation> List<T> appendAnnotations(List<T> l, Class<T> a, boolean parentFirst) {
        if (this.eInfo.isConstructor) {
            ClassInfo ci = this.eInfo.getParamType(this.index).resolved();
            Annotation[] annotations = this.eInfo.getParameterAnnotations(this.index);
            if (parentFirst) {
                ci.appendAnnotations(l, a);
                for (Annotation a2 : annotations) {
                    if (!a.isInstance(a2)) continue;
                    l.add(a2);
                }
            } else {
                for (Annotation a2 : annotations) {
                    if (!a.isInstance(a2)) continue;
                    l.add(a2);
                }
                ci.appendAnnotations(l, a);
            }
        } else {
            MethodInfo mi = (MethodInfo)this.eInfo;
            ClassInfo ci = this.eInfo.getParamType(this.index).resolved();
            if (parentFirst) {
                ci.appendAnnotations(l, a);
                for (Method m2 : mi.getMatchingParentFirst()) {
                    for (Annotation a2 : m2.getParameterAnnotations()[this.index]) {
                        if (!a.isInstance(a2)) continue;
                        l.add(a2);
                    }
                }
            } else {
                for (Method m2 : mi.getMatching()) {
                    for (Annotation a2 : m2.getParameterAnnotations()[this.index]) {
                        if (!a.isInstance(a2)) continue;
                        l.add(a2);
                    }
                }
                ci.appendAnnotations(l, a);
            }
        }
        return l;
    }

    private synchronized Map<Class<?>, Optional<Annotation>> annotationMap() {
        if (this.annotationMap == null) {
            this.annotationMap = new ConcurrentHashMap();
        }
        return this.annotationMap;
    }

    public boolean hasName() {
        return this.p.isNamePresent() || this.p.isAnnotationPresent(Name.class);
    }

    public String getName() {
        Name n = this.p.getAnnotation(Name.class);
        if (n != null) {
            return n.value();
        }
        if (this.p.isNamePresent()) {
            return this.p.getName();
        }
        return null;
    }

    public String toString() {
        return this.eInfo.getSimpleName() + "[" + this.index + "]";
    }
}

