/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.EntityTag;
import org.apache.juneau.internal.StringUtils;

public class BasicEntityTagHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private EntityTag parsed;

    public static BasicEntityTagHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicEntityTagHeader(name, value);
    }

    public static BasicEntityTagHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicEntityTagHeader(name, value);
    }

    public BasicEntityTagHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.getParsedValue();
        }
    }

    @Override
    public String getValue() {
        Object o = this.getRawValue();
        if (o instanceof String) {
            return (String)o;
        }
        return StringUtils.stringify(this.asEntityTag());
    }

    public EntityTag asEntityTag() {
        return this.getParsedValue();
    }

    private EntityTag getParsedValue() {
        if (this.parsed != null) {
            return this.parsed;
        }
        return EntityTag.of(this.getRawValue());
    }
}

