/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.AbstractSTRtree;
import org.locationtech.jts.index.strtree.STRtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STRtreePerGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<Node, STRtree> treeMap;
    private Map<Node, STRtree> treeMapView;
    private boolean isBuilt = false;

    public STRtreePerGraph() {
        this(new ConcurrentHashMap<Node, STRtree>());
    }

    public STRtreePerGraph(STRtree defaultTree) {
        this(new ConcurrentHashMap<Node, STRtree>());
        Objects.requireNonNull(defaultTree);
        this.setDefaultTree(defaultTree);
    }

    protected STRtreePerGraph(Map<Node, STRtree> treeMap) {
        this.treeMap = Objects.requireNonNull(treeMap);
        this.treeMapView = Collections.unmodifiableMap(this.treeMap);
    }

    public STRtree getDefaultTree() {
        return this.treeMap.get(Quad.defaultGraphIRI);
    }

    public Map<Node, STRtree> getTreeMap() {
        return this.treeMapView;
    }

    Map<Node, STRtree> getInternalTreeMap() {
        return this.treeMap;
    }

    public boolean contains(Node name) {
        return this.getTree(name) != null;
    }

    public STRtree getTree(Node name) {
        STRtree result = name == null || Quad.isDefaultGraph(name) ? this.treeMap.get(Quad.defaultGraphIRI) : this.treeMap.get(name);
        return result;
    }

    public STRtree setTree(Node name, STRtree tree) {
        STRtree result = name == null || Quad.isDefaultGraph(name) ? this.setDefaultTree(tree) : this.setNamedTree(name, tree);
        return result;
    }

    public STRtree setDefaultTree(STRtree tree) {
        return this.setNamedTree(Quad.defaultGraphIRI, tree);
    }

    protected STRtree setNamedTree(Node graphNode, STRtree tree) {
        Objects.requireNonNull(graphNode);
        return this.treeMap.put(graphNode, tree);
    }

    public void setTrees(Map<Node, STRtree> treeMap) {
        if (this.isBuilt()) {
            treeMap.values().forEach(AbstractSTRtree::build);
        }
        this.treeMap.putAll(treeMap);
    }

    public boolean removeTree(Node node) {
        if (node == null) {
            node = Quad.defaultGraphIRI;
        }
        return this.treeMap.remove(node) != null;
    }

    public Collection<Node> queryOneGraph(Envelope searchEnvelope, Node graph) {
        Collection result;
        if (graph == null || Quad.isDefaultGraph(graph)) {
            STRtree defaultTree = this.getDefaultTree();
            result = defaultTree == null ? Set.of() : new LinkedHashSet(defaultTree.query(searchEnvelope));
        } else if (Quad.isUnionGraph(graph)) {
            LOGGER.warn("spatial index lookup on union graph");
            result = this.treeMap.entrySet().stream().filter(e2 -> !Quad.isDefaultGraph((Node)e2.getKey())).map(Map.Entry::getValue).map(tree -> tree.query(searchEnvelope)).collect(LinkedHashSet::new, Set::addAll, Set::addAll);
        } else {
            STRtree tree2 = this.treeMap.get(graph);
            if (tree2 == null) {
                LOGGER.warn("graph not indexed: " + String.valueOf(graph));
            }
            result = tree2 != null && !tree2.isEmpty() ? new LinkedHashSet(tree2.query(searchEnvelope)) : new HashSet();
        }
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.treeMap.values().stream().allMatch(AbstractSTRtree::isEmpty);
        return result;
    }

    public void build() {
        if (!this.isBuilt) {
            this.treeMap.values().forEach(AbstractSTRtree::build);
            this.isBuilt = true;
        }
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public long size() {
        long result = this.treeMap.values().stream().mapToLong(STRtree::size).sum();
        return result;
    }
}

