/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cdt.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.cdt.CDTFactory;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTLiteralParserBase;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.parser.CDTLiteralParserConstants;
import org.apache.jena.cdt.parser.CDTLiteralParserTokenManager;
import org.apache.jena.cdt.parser.JavaCharStream;
import org.apache.jena.cdt.parser.ParseException;
import org.apache.jena.cdt.parser.Token;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.lang.extra.LangParserLib;

public class CDTLiteralParser
extends CDTLiteralParserBase
implements CDTLiteralParserConstants {
    public CDTLiteralParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    public final List<CDTValue> List() throws ParseException {
        ArrayList<CDTValue> l = new ArrayList<CDTValue>();
        this.jj_consume_token(29);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 29: {
                this.NonEmptyListContent(l);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.jj_consume_token(30);
        return l;
    }

    public final void NonEmptyListContent(List<CDTValue> l) throws ParseException {
        this.ListElement(l);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(31);
            this.ListElement(l);
        }
    }

    public final void ListElement(List<CDTValue> l) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                String iri2 = this.IRI_REF();
                Node n = this.createURI(iri2, this.token.beginLine, this.token.beginColumn);
                l.add(CDTFactory.createValue(n));
                break;
            }
            case 22: {
                Node n = this.BlankNode();
                l.add(CDTFactory.createValue(n));
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                Node n = this.RDFLiteral();
                l.add(CDTFactory.createValue(n));
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                Node n = this.NumericLiteral();
                l.add(CDTFactory.createValue(n));
                break;
            }
            case 7: 
            case 8: {
                Node n = this.BooleanLiteral();
                l.add(CDTFactory.createValue(n));
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                l.add(CDTFactory.getNullValue());
                break;
            }
            case 29: {
                List<CDTValue> subList = this.List();
                l.add(CDTFactory.createValue(subList));
                break;
            }
            case 27: {
                Map<CDTKey, CDTValue> m = this.Map();
                l.add(CDTFactory.createValue(m));
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Map<CDTKey, CDTValue> Map() throws ParseException {
        HashMap<CDTKey, CDTValue> m = new HashMap<CDTKey, CDTValue>();
        this.jj_consume_token(27);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                this.NonEmptyMapContent(m);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(28);
        return m;
    }

    public final void NonEmptyMapContent(Map<CDTKey, CDTValue> m) throws ParseException {
        this.MapEntry(m);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(31);
            this.MapEntry(m);
        }
    }

    public final void MapEntry(Map<CDTKey, CDTValue> m) throws ParseException {
        CDTKey key = this.MapKey();
        this.jj_consume_token(32);
        CDTValue value = this.MapValue();
        CDTValue oldValue = m.put(key, value);
        if (oldValue != null) {
            throw new ParseException("map with non-unique key (" + key.toString() + ")");
        }
    }

    public final CDTKey MapKey() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                String iri2 = this.IRI_REF();
                Node n = this.createURI(iri2, this.token.beginLine, this.token.beginColumn);
                return CDTFactory.createKey(n);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                Node n = this.RDFLiteral();
                return CDTFactory.createKey(n);
            }
            case 9: 
            case 10: 
            case 11: {
                Node n = this.NumericLiteral();
                return CDTFactory.createKey(n);
            }
            case 7: 
            case 8: {
                Node n = this.BooleanLiteral();
                return CDTFactory.createKey(n);
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final CDTValue MapValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                String iri2 = this.IRI_REF();
                Node n = this.createURI(iri2, this.token.beginLine, this.token.beginColumn);
                return CDTFactory.createValue(n);
            }
            case 22: {
                Node n = this.BlankNode();
                return CDTFactory.createValue(n);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                Node n = this.RDFLiteral();
                return CDTFactory.createValue(n);
            }
            case 9: 
            case 10: 
            case 11: {
                Node n = this.NumericLiteral();
                return CDTFactory.createValue(n);
            }
            case 7: 
            case 8: {
                Node n = this.BooleanLiteral();
                return CDTFactory.createValue(n);
            }
            case 26: {
                this.jj_consume_token(26);
                return CDTFactory.getNullValue();
            }
            case 29: {
                List<CDTValue> subList = this.List();
                return CDTFactory.createValue(subList);
            }
            case 27: {
                Map<CDTKey, CDTValue> m = this.Map();
                return CDTFactory.createValue(m);
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String IRI_REF() throws ParseException {
        Token t = this.jj_consume_token(21);
        return this.resolveQuotedIRI(t.image, t.beginLine, t.beginColumn);
    }

    public final Node BlankNode() throws ParseException {
        Token t = null;
        t = this.jj_consume_token(22);
        return this.createBNode(t.image, t.beginLine, t.beginColumn);
    }

    public final Node NumericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                Token t = this.jj_consume_token(9);
                return this.createLiteralInteger(t.image, t.beginLine, t.beginColumn);
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                return this.createLiteralDecimal(t.image, t.beginLine, t.beginColumn);
            }
            case 11: {
                Token t = this.jj_consume_token(11);
                return this.createLiteralDouble(t.image, t.beginLine, t.beginColumn);
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                return this.XSD_TRUE;
            }
            case 8: {
                this.jj_consume_token(8);
                return this.XSD_FALSE;
            }
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node RDFLiteral() throws ParseException {
        String lex = null;
        lex = this.String();
        String lang = null;
        String dt = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: 
            case 33: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        lang = this.Langtag();
                        break block0;
                    }
                    case 33: {
                        this.jj_consume_token(33);
                        dt = this.IRI_REF();
                        break block0;
                    }
                }
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        return this.createLiteral(lex, lang, dt, this.token.beginLine, this.token.beginColumn);
    }

    public final String Langtag() throws ParseException {
        Token t = this.jj_consume_token(23);
        String lang = LangParserLib.stripChars(t.image, 1);
        return lang;
    }

    public final String String() throws ParseException {
        Token t;
        String lex = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16 -> {
                t = this.jj_consume_token(16);
                yield LangParserLib.stripQuotes(t.image);
            }
            case 17 -> {
                t = this.jj_consume_token(17);
                yield LangParserLib.stripQuotes(t.image);
            }
            case 18 -> {
                t = this.jj_consume_token(18);
                yield LangParserLib.stripQuotes3(t.image);
            }
            case 19 -> {
                t = this.jj_consume_token(19);
                yield LangParserLib.stripQuotes3(t.image);
            }
            default -> {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        lex = LangParserLib.unescapeStr(lex, t.beginLine, t.beginColumn);
        return lex;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{745475968, Integer.MIN_VALUE, 745475968, 3084160, Integer.MIN_VALUE, 3084160, 745475968, 3584, 384, 0x800000, 0x800000, 983040};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0};
    }

    public CDTLiteralParser(InputStream stream) {
        this(stream, null);
    }

    public CDTLiteralParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source = new CDTLiteralParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public CDTLiteralParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new CDTLiteralParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new CDTLiteralParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public CDTLiteralParser(CDTLiteralParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(CDTLiteralParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[40];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 12; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 40; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        CDTLiteralParser.jj_la1_init_0();
        CDTLiteralParser.jj_la1_init_1();
    }
}

