/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shex.expressions.ShexPrintable;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

class ShexPrintOps {
    private static PrefixMap displayPrefixMap = PrefixMapFactory.createForOutput();
    public static NodeFormatter nodeFmtAbbrev;

    ShexPrintOps() {
    }

    public static void print(ShexPrintable printable) {
        IndentedWriter iOut = IndentedWriter.clone((IndentedWriter)IndentedWriter.stdout);
        NodeFormatterTTL nFmt = new NodeFormatterTTL(null, PrefixMapFactory.create((PrefixMapping)SSE.getPrefixMapRead()));
        printable.print(iOut, (NodeFormatter)nFmt);
    }

    public static String asString(ShexPrintable printable) {
        IndentedLineBuffer x = new IndentedLineBuffer();
        x.setFlatMode(true);
        printable.print((IndentedWriter)x, nodeFmtAbbrev);
        return x.asString();
    }

    static {
        displayPrefixMap.add("owl", OWL.getURI());
        displayPrefixMap.add("rdf", RDF.getURI());
        displayPrefixMap.add("rdfs", RDFS.getURI());
        displayPrefixMap.add("xsd", XSD.getURI());
        nodeFmtAbbrev = new NodeFormatterTTL(null, displayPrefixMap);
    }
}

